/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.devices;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.IDeviceListener;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import com.gc5.iSMA_IO.networks.BIsmaRemoteIpNetwork;
import com.gc5.iSMA_IO.networks.BIsmaRemoteSerialNetwork;
import com.gc5.iSMA_IO.points.IWritablePoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="ping"), @NiagaraAction(name="forceWriteConfig"), @NiagaraAction(name="writePoints")})
@NiagaraProperties(value={@NiagaraProperty(name="deviceAddress", type="int", flags=0, defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="255")}), @NiagaraProperty(name="deviceType", type="String", flags=65, defaultValue="Unknown"), @NiagaraProperty(name="firmwareVersion", type="String", flags=65, defaultValue="Unknown"), @NiagaraProperty(name="maxWriteTime", type="BRelTime", defaultValue="BRelTime.make(0L)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0L)"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")")}), @NiagaraProperty(name="writeOnStart", type="boolean", defaultValue="true"), @NiagaraProperty(name="writeOnUp", type="boolean", defaultValue="true"), @NiagaraProperty(name="writeOnEnabled", type="boolean", defaultValue="true")})
public class BIsmaRemoteDevice
extends BIsmaCommonIoDevice {
    public static final Property deviceAddress = BIsmaRemoteDevice.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)255)));
    public static final Property deviceType = BIsmaRemoteDevice.newProperty((int)65, (String)"Unknown", null);
    public static final Property firmwareVersion = BIsmaRemoteDevice.newProperty((int)65, (String)"Unknown", null);
    public static final Property maxWriteTime = BIsmaRemoteDevice.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    public static final Property writeOnStart = BIsmaRemoteDevice.newProperty((int)0, (boolean)true, null);
    public static final Property writeOnUp = BIsmaRemoteDevice.newProperty((int)0, (boolean)true, null);
    public static final Property writeOnEnabled = BIsmaRemoteDevice.newProperty((int)0, (boolean)true, null);
    public static final Action ping = BIsmaRemoteDevice.newAction((int)0, null);
    public static final Action forceWriteConfig = BIsmaRemoteDevice.newAction((int)0, null);
    public static final Action writePoints = BIsmaRemoteDevice.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BIsmaRemoteDevice.class);
    private Clock.Ticket writePeriodicallyTicket;
    private static final BIcon icon = BIcon.std((String)"device.png");

    public int getDeviceAddress() {
        return this.getInt(deviceAddress);
    }

    public void setDeviceAddress(int v) {
        this.setInt(deviceAddress, v, null);
    }

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    public BRelTime getMaxWriteTime() {
        return (BRelTime)this.get(maxWriteTime);
    }

    public void setMaxWriteTime(BRelTime v) {
        this.set(maxWriteTime, (BValue)v, null);
    }

    public boolean getWriteOnStart() {
        return this.getBoolean(writeOnStart);
    }

    public void setWriteOnStart(boolean v) {
        this.setBoolean(writeOnStart, v, null);
    }

    public boolean getWriteOnUp() {
        return this.getBoolean(writeOnUp);
    }

    public void setWriteOnUp(boolean v) {
        this.setBoolean(writeOnUp, v, null);
    }

    public boolean getWriteOnEnabled() {
        return this.getBoolean(writeOnEnabled);
    }

    public void setWriteOnEnabled(boolean v) {
        this.setBoolean(writeOnEnabled, v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void forceWriteConfig() {
        this.invoke(forceWriteConfig, null, null);
    }

    public void writePoints() {
        this.invoke(writePoints, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void doPing() {
        this.pingDevice();
    }

    public void doForceWriteConfig() {
        for (IDeviceListener listener : this.getListeners()) {
            listener.sendConfigurations();
        }
    }

    public void doWritePoints() {
        for (IDeviceListener listener : this.getListeners()) {
            if (!(listener instanceof IWritablePoint)) continue;
            ((IWritablePoint)((Object)listener)).doForceWrite();
        }
    }

    public void updateWritePeriodically() {
        if (this.writePeriodicallyTicket != null) {
            this.writePeriodicallyTicket.cancel();
        }
        if (!this.getMaxWriteTime().equals((Object)BRelTime.make((long)0L))) {
            this.writePeriodicallyTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getMaxWriteTime(), (Action)writePoints, null);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        this.updateWritePeriodically();
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == deviceAddress) {
            this.devAddr = this.getDeviceAddress();
            this.sendDeviceTypeVersionReq();
        }
        if (property == maxWriteTime) {
            this.updateWritePeriodically();
        }
        this.notifyObservers(x -> x.deviceUpdated(property));
    }

    @Override
    void setDeviceName(String name) {
        this.setDeviceType(name);
    }

    @Override
    void setDeviceFirmwareVersion(String version) {
        this.setFirmwareVersion(version);
    }

    @Override
    int getDevAddr() {
        return this.getDeviceAddress();
    }

    @Override
    public BIsmaNetwork getNetwork() {
        BComponent parentComponent = this.getParent().getParentComponent();
        while (parentComponent != null && !parentComponent.getType().is(BIsmaRemoteSerialNetwork.TYPE) && !parentComponent.getType().is(BIsmaRemoteIpNetwork.TYPE)) {
            BComplex parent = parentComponent.getParent();
            if (parent != null) {
                parentComponent = parent.getParentComponent();
                continue;
            }
            return null;
        }
        if (parentComponent != null && (parentComponent.getType().is(BIsmaRemoteSerialNetwork.TYPE) || parentComponent.getType().is(BIsmaRemoteIpNetwork.TYPE))) {
            return (BIsmaNetwork)parentComponent;
        }
        return null;
    }

    @Override
    protected boolean checkDeviceNumber() {
        this.devAddr = this.getDeviceAddress();
        return this.devAddr < deviceAddress.getFacets().geti("min", 0) || this.devAddr > deviceAddress.getFacets().geti("max", 0);
    }
}

