/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.devices;

import com.gc5.iSMA_IO.devices.BIsmaCommonIoDevice;
import com.gc5.iSMA_IO.devices.DeviceTypes;
import com.gc5.iSMA_IO.enums.Utilities.Statuses;
import com.gc5.iSMA_IO.messages.ModbusMessage;
import com.gc5.iSMA_IO.networks.BIsmaIoNetwork;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BIsmaIoDevice
extends BIsmaCommonIoDevice {
    public static final Type TYPE = Sys.loadType(BIsmaIoDevice.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    int getDevAddr() {
        return 1;
    }

    @Override
    public BIsmaNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        BComponent parentComponent = this.getParent().getParentComponent();
        while (parentComponent != null && !parentComponent.getType().is(BIsmaIoNetwork.TYPE)) {
            BComplex parent = parentComponent.getParent();
            if (parent != null) {
                parentComponent = parent.getParentComponent();
                continue;
            }
            return null;
        }
        if (parentComponent != null && parentComponent.getType().is(BIsmaIoNetwork.TYPE)) {
            return (BIsmaNetwork)parentComponent;
        }
        return null;
    }

    @Override
    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.started();
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        this.notifyObservers(x -> x.deviceUpdated(property));
    }

    public void networkStarted() {
        this.sendDeviceTypeVersionReq();
    }

    @Override
    public boolean updateDeviceTypeVersion(ModbusMessage mm) {
        try {
            if (!mm.parseResponse()) {
                this.updateDeviceStatus(Statuses.DEVICE_DOWN);
                return false;
            }
            int typeVersionRegister = mm.getRegister(0);
            int deviceType = typeVersionRegister & 0x7F;
            String deviceName = DeviceTypes.getDeviceType(deviceType);
            if (deviceName == null) {
                this.updateDeviceStatus(Statuses.INVALID_DEVICE);
                return false;
            }
            this.deviceCapabilities = DeviceTypes.getDeviceCapabilities(deviceType);
            this.updateDeviceStatus(Statuses.STATUS_UNKNOWN_YET);
            this.notifyObservers(x -> x.devicePinged());
            if (!this.deviceIsReady) {
                this.deviceIsReady = true;
                this.notifyObservers(x -> x.deviceConfirmed());
            }
            return true;
        }
        catch (Exception ex) {
            this.log.severe(ex.getLocalizedMessage());
            throw ex;
        }
    }

    @Override
    protected boolean checkDeviceNumber() {
        return false;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"device.png");
    }
}

