/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.comm;

import com.gc5.iSMA_IO.comm.BasicComm;
import com.gc5.iSMA_IO.models.CommunicationParametersModel;
import com.gc5.iSMA_IO.models.TcpCommunicationParametersModel;
import com.gc5.iSMA_IO.networks.BIsmaNetwork;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;

public class TcpComm
implements BasicComm {
    public Socket sock;
    SocketAddress sockAddr;
    int modbusCnt = 0;
    private TcpCommunicationParametersModel communicationModel;
    public static final Logger log = Logger.getLogger("iSMA_IO::TcpCommunication");

    public TcpComm(BIsmaNetwork network) {
        this.communicationModel = new TcpCommunicationParametersModel();
        this.communicationModel.network = network;
    }

    public TcpComm(TcpCommunicationParametersModel model) {
        this.communicationModel = model;
    }

    @Override
    public boolean write(byte[] data) {
        if (this.sock == null || !this.sock.isConnected()) {
            return false;
        }
        if (this.modbusCnt >= 65535) {
            this.modbusCnt = 0;
        }
        byte[] tcpHeader = new byte[]{(byte)((this.modbusCnt & 0xFF00) >> 8), (byte)(this.modbusCnt & 0xFF), 0, 0, (byte)((data.length & 0xFF00) >> 8), (byte)(data.length & 0xFF)};
        try {
            OutputStream out = this.sock.getOutputStream();
            byte[] tempArr = new byte[tcpHeader.length + data.length];
            System.arraycopy(tcpHeader, 0, tempArr, 0, tcpHeader.length);
            System.arraycopy(data, 0, tempArr, tcpHeader.length, data.length);
            out.write(tempArr);
            out.flush();
            log.fine("Data sent: " + ByteArrayUtil.toHexString((byte[])tempArr).substring(12));
            ++this.modbusCnt;
            return true;
        }
        catch (SocketException se) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public byte[] receive() throws IOException {
        byte[] ibuf = new byte[261];
        int rxSize = 0;
        try {
            InputStream in = this.sock.getInputStream();
            int dataLen = 256;
            do {
                int x;
                try {
                    x = in.read();
                }
                catch (Exception e) {
                    log.severe("Read exception: " + e.getLocalizedMessage());
                    return null;
                }
                if (x < 0) {
                    throw new SocketException("End of stream.");
                }
                ibuf[rxSize++] = (byte)x;
                if (rxSize != 6) continue;
                dataLen = x;
            } while (rxSize < dataLen + 6 || rxSize < 9);
            if ((ibuf[7] & 0x80) != 0) {
                throw new IOException("Exception response: type " + ibuf[8]);
            }
            byte[] rxData = new byte[rxSize - 6];
            System.arraycopy(ibuf, 6, rxData, 0, rxData.length);
            int transactionId = (ibuf[0] & 0xFF) << 8;
            if ((transactionId |= ibuf[1] & 0xFF) != this.modbusCnt - 1) {
                log.severe("Wrong transaction ID");
                return null;
            }
            int protocolId = (ibuf[2] & 0xFF) << 8;
            if ((protocolId |= ibuf[3] & 0xFF) != 0) {
                log.severe("Wrong protocol ID");
                return null;
            }
            log.fine("Data received: " + ByteArrayUtil.toHexString((byte[])rxData));
            return rxData;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.severe("Socket closed: " + e.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public void close() {
        try {
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
                log.finest(this.communicationModel.ipAddress + ":" + this.communicationModel.portNumber + ": Socket closed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean open() {
        try {
            this.sockAddr = new InetSocketAddress(this.communicationModel.ipAddress, this.communicationModel.portNumber);
            this.sock = new Socket();
            this.sock.setSoTimeout(this.communicationModel.socketOptionTimeout);
            this.sock.connect(this.sockAddr, this.communicationModel.connectTimeout);
            log.finest(this.communicationModel.ipAddress + ":" + this.communicationModel.portNumber + ": Socket opened successfully.");
            return true;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public boolean isClosed() {
        return this.sock == null || this.sock.isClosed();
    }

    @Override
    public CommunicationParametersModel getCommunicationModel() {
        return this.communicationModel;
    }
}

