/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.comm;

import com.gc5.iSMA_IO.comm.BasicComm;
import com.gc5.iSMA_IO.comm.CRC16;
import com.gc5.iSMA_IO.models.CommunicationParametersModel;
import com.gc5.iSMA_IO.models.SerialCommunicationParametersModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SerialComm
implements BasicComm {
    private String portName;
    private BISerialPort port = null;
    private static String[] serialPorts = null;
    private SerialCommunicationParametersModel communicationModel;
    private static final Logger log = Logger.getLogger("iSMA_IO::SerialCommunication");

    public SerialComm(String portName) {
        this.portName = portName;
    }

    static BISerialService getMyBISerialService() {
        BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        ((BComponent)platSvc).lease();
        platSvc.checkPropertiesLoaded();
        return platSvc;
    }

    public static String[] getSerialPorts() {
        if (serialPorts != null) {
            return serialPorts;
        }
        serialPorts = SerialComm.getMyBISerialService().getPortNames();
        return serialPorts;
    }

    public SerialComm(SerialCommunicationParametersModel serialCommunicationParametersModel) throws Exception {
        this.communicationModel = serialCommunicationParametersModel;
        this.port = SerialComm.getMyBISerialService().openPort(serialCommunicationParametersModel.comPort, "RemoteIo" + serialCommunicationParametersModel.comPort);
        this.port.setSerialPortParams((BBaudRate)serialCommunicationParametersModel.baudrate, serialCommunicationParametersModel.dataBits, serialCommunicationParametersModel.stopBits, serialCommunicationParametersModel.parityBits);
        this.port.enableReceiveTimeout(serialCommunicationParametersModel.timeout);
    }

    @Override
    public void close() {
        if (this.port != null) {
            log.fine("Closing port: " + this.port);
            this.port.close();
            this.port = null;
        }
    }

    @Override
    public boolean write(byte[] data) {
        this.clearInputBuffer();
        int crc = CRC16.calc(data, 0, data.length);
        byte[] dataToSend = new byte[data.length + 2];
        ByteArrayUtil.copy((byte[])data, (byte[])dataToSend);
        dataToSend[data.length] = (byte)(crc & 0xFF);
        dataToSend[data.length + 1] = (byte)(crc >> 8 & 0xFF);
        try {
            this.port.getOutputStream().write(dataToSend);
            log.fine("Data sent: " + ByteArrayUtil.toHexString((byte[])dataToSend));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    private void clearInputBuffer() {
        if (this.port == null) {
            return;
        }
        try {
            InputStream inputStream = this.port.getInputStream();
            int availableInputData = inputStream.available();
            if (availableInputData > 0) {
                inputStream.skip(availableInputData);
            }
        }
        catch (Exception ex) {
            ex.getLocalizedMessage();
        }
    }

    @Override
    public byte[] receive() {
        try {
            byte[] readBuffer = new byte[256];
            BufferedInputStream buf = new BufferedInputStream(this.port.getInputStream());
            int bufLen = buf.read(readBuffer);
            if (bufLen > 0) {
                readBuffer = Arrays.copyOf(readBuffer, bufLen);
                log.fine("Data received: " + ByteArrayUtil.toHexString((byte[])readBuffer));
            } else {
                readBuffer = null;
            }
            return readBuffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CommunicationParametersModel getCommunicationModel() {
        return this.communicationModel;
    }
}

