/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.ui;

import com.tridium.email.ui.BEmailAddressFE;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BEmailAddressListFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BEmailAddressListFE.class);
    private BEmailAddressList addressList = null;
    private BGridPane contentPane;
    private Command addCommand;
    private Command deleteCommand;

    public Type getType() {
        return TYPE;
    }

    public BEmailAddressListFE() {
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        button.setPadding(BInsets.NULL);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.none);
        button.setPadding(BInsets.NULL);
        BGridPane outerGrid = new BGridPane(2);
        this.contentPane = new BGridPane(1);
        outerGrid.add(null, (BValue)this.contentPane);
        outerGrid.add(null, (BValue)toolbarPane);
        outerGrid.setHalign(BHalign.left);
        outerGrid.setValign(BValign.bottom);
        outerGrid.setColumnAlign(BHalign.center);
        outerGrid.setRowAlign(BValign.bottom);
        this.contentPane.setRowGap(5.0);
        this.contentPane.setRowAlign(BValign.center);
        this.setContent((BWidget)outerGrid);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.contentPane.removeAll();
        this.addressList = (BEmailAddressList)value;
        BEmailAddress[] addresses = this.addressList.getAddresses();
        for (int i = 0; i < addresses.length; ++i) {
            this.addElement(addresses[i]);
        }
        if (addresses.length == 0) {
            this.addElement(BEmailAddress.DEFAULT);
        }
        this.deleteCommand.setEnabled(this.contentPane.getChildWidgets().length > 1);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BEmailAddressFE[] addressFEs = (BEmailAddressFE[])this.contentPane.getChildren(BEmailAddressFE.class);
        Array addresses = new Array(BEmailAddress.class);
        for (int i = 0; i < addressFEs.length; ++i) {
            BEmailAddress address = (BEmailAddress)addressFEs[i].saveValue();
            if (address.isNull()) continue;
            addresses.add((Object)address);
        }
        return BEmailAddressList.make((BEmailAddress[])((BEmailAddress[])addresses.trim()));
    }

    protected void doSetReadonly(boolean readonly) {
        BEmailAddressFE[] addressFEs = (BEmailAddressFE[])this.contentPane.getChildren(BEmailAddressFE.class);
        for (int i = 0; i < addressFEs.length; ++i) {
            addressFEs[i].setReadonly(readonly);
        }
        this.deleteCommand.setEnabled(!readonly);
        this.addCommand.setEnabled(!readonly);
        super.doSetReadonly(readonly);
    }

    private void addElement(BEmailAddress address) {
        BEmailAddressFE addressFE = new BEmailAddressFE(this.contentPane.getChildWidgets().length == 0);
        addressFE.setReadonly(this.isReadonly());
        addressFE.loadValue((BObject)address);
        this.contentPane.add(null, (BValue)addressFE, 0);
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.deleteCommand.setEnabled(this.contentPane.getChildWidgets().length > 1);
        this.linkTo(null, (BComponent)addressFE, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BEmailAddressListFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            BEmailAddressListFE.this.addElement(BEmailAddress.DEFAULT);
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BEmailAddressListFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BWidget[] children = BEmailAddressListFE.this.contentPane.getChildWidgets();
            if (children.length > 1) {
                BEmailAddressListFE.this.contentPane.remove((BComplex)children[children.length - 1]);
                BEmailAddressListFE.this.setModified();
                BEmailAddressListFE.this.relayout();
            }
            BEmailAddressListFE.this.deleteCommand.setEnabled(BEmailAddressListFE.this.contentPane.getChildWidgets().length > 1);
            return null;
        }
    }
}

