/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.watch;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.server.BObixOp;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import com.tridium.obix.watch.BObixWatch;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"obixDriver:ObixLobby"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="make", type="obixDriver:ObixOp", defaultValue="new BObixOp(\"make\", URN_NIL, URN_WATCH)", flags=256), @NiagaraProperty(name="defaultLeaseTime", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(30)")})
public class BObixWatchService
extends BObixAgent
implements BIObixLobbyAgent,
BObixOp.Parent {
    public static final String URN_WATCH = "obix:Watch";
    public static final String URN_WATCH_SERVICE = "obix:WatchService";
    public static final String WATCH_SERVICE = "watchService";
    public static final Property make = BObixWatchService.newProperty((int)256, (BValue)new BObixOp("make", "obix:Nil", "obix:Watch"), null);
    public static final Property defaultLeaseTime = BObixWatchService.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    public static final Type TYPE = Sys.loadType(BObixWatchService.class);

    public BObixOp getMake() {
        return (BObixOp)this.get(make);
    }

    public void setMake(BObixOp v) {
        this.set(make, (BValue)v, null);
    }

    public BRelTime getDefaultLeaseTime() {
        return (BRelTime)this.get(defaultLeaseTime);
    }

    public void setDefaultLeaseTime(BRelTime v) {
        this.set(defaultLeaseTime, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeLobbyChild(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj("ref");
            o.setHref(out.getHref());
            o.setName(WATCH_SERVICE);
            o.setIs(URN_WATCH_SERVICE);
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    @Override
    public String getLobbyName() {
        return WATCH_SERVICE;
    }

    @Override
    public synchronized void invoke(BObixOp op, ObixDecoder in, ObixEncoder out) {
        String name = this.makeName();
        BObixWatch watch = new BObixWatch();
        watch.setUser(in.getUser());
        watch.setLease(this.getDefaultLeaseTime());
        this.add(name, (BValue)watch, 256);
        String href = out.getHref();
        href = href.substring(0, href.indexOf("make"));
        out.setHref(ObixUtils.concat(ObixUtils.concat(href, name), "/"));
        BOrd o = BOrd.make((String)"station:");
        o = BOrd.make((BOrd)o, (BOrd)watch.getSlotPathOrd());
        out.encode(o.resolve(null, (Context)in));
    }

    @Override
    public OrdTarget resolve(String uri, Context cx) {
        this.checkExpired();
        try {
            BOrd o = BOrd.make((String)"station:");
            o = BOrd.make((BOrd)o, (BOrd)this.getSlotPathOrd());
            if (uri == null || uri.isEmpty() || "/".equals(uri)) {
                return o.resolve((BObject)Sys.getStation(), cx);
            }
            uri = uri.endsWith("/") ? uri.substring(1, uri.length() - 1) : uri.substring(1);
            o = BOrd.make((BOrd)o, (String)("slot:" + uri));
            return o.resolve((BObject)Sys.getStation(), cx);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return URN_WATCH_SERVICE;
        }
        return value;
    }

    void checkExpired() {
        BObixWatch[] kids = (BObixWatch[])this.getChildren(BObixWatch.class);
        if (kids == null) {
            return;
        }
        int i = kids.length;
        while (--i >= 0) {
            if (!kids[i].isExpired()) continue;
            this.remove((BComplex)kids[i]);
        }
    }

    private String makeName() {
        int i = (int)System.currentTimeMillis();
        if (i < 0) {
            i = -i;
        }
        String s;
        while (this.get(s = "watch" + i) != null) {
            ++i;
        }
        return s;
    }
}

