/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BObixHistoryAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import java.util.StringTokenizer;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public class BObixHistoryQuery
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    public static final Type TYPE = Sys.loadType(BObixHistoryQuery.class);
    BIHistory history;
    String query;

    public Type getType() {
        return TYPE;
    }

    public BObixHistoryQuery(BIHistory history, OrdQuery query) {
        this.history = history;
        this.query = BObixHistoryQuery.parseQuery(query);
    }

    private static String parseQuery(OrdQuery oq) {
        String body = oq.getBody();
        int qMark = body.indexOf(63);
        return qMark < 0 ? null : body.substring(qMark + 1);
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        if (this.query == null) {
            Obj obj = new Obj();
            obj.initOp("query", "obix:HistoryFilter", "obix:HistoryQueryOut");
            obj.setHref(out.getHref());
            obj.write(out, false);
        } else {
            BInteger limit = BInteger.MAX;
            BAbsTime start = null;
            BAbsTime end = null;
            try {
                StringTokenizer st = new StringTokenizer(this.query, "&");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int ndx = token.indexOf(61);
                    String param = token.substring(0, ndx);
                    String val = token.substring(ndx + 1);
                    switch (param) {
                        case "start": {
                            start = ObixUtils.dateTime(val);
                            break;
                        }
                        case "end": {
                            end = ObixUtils.dateTime(val);
                            break;
                        }
                        case "limit": {
                            limit = BInteger.make((int)ObixUtils.num(val, limit.getInt()));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Obj obj = new Obj().setIs("obix:HistoryQueryOut");
            obj.setHref(out.getHref());
            obj.write(out, true);
            obj.initList("data", "#RecordDef obix:HistoryRecord").write(out, true);
            out.commit();
            try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
                BTimeZone targetTimeZone = this.history.getConfig().getTimeZone();
                if (start != null) {
                    start = BAbsTime.make((BAbsTime)start, (BTimeZone)targetTimeZone);
                }
                if (end != null) {
                    end = BAbsTime.make((BAbsTime)end, (BTimeZone)targetTimeZone);
                }
                BITable results = conn.timeQuery(this.history, start, end);
                OrdTarget base = this.history.getOrdInSession().resolve(null, cx);
                out.setName(null);
                out.setHref(null);
                out.setEncodeIs(false);
                BFacets valueFacets = (BFacets)this.history.getConfig().get("valueFacets");
                if (valueFacets == null) {
                    valueFacets = BFacets.DEFAULT;
                }
                BTimeZone tz = this.history.getConfig().getTimeZone();
                BObixHistoryAgent.QueryResults res = BObixHistoryAgent.iterateQueryResults(out, (BITable<BHistoryRecord>)results, limit, base, tz);
                obj.initList(null, null).endElem(out);
                obj.initInt("count", res.count).write(out, false);
                if (res.first != null) {
                    obj.initAbstime("start", BAbsTime.make((BAbsTime)res.first.getTimestamp(), (BTimeZone)tz)).write(out, false);
                } else if (start != null) {
                    obj.initAbstime("start", BAbsTime.make((BAbsTime)start, (BTimeZone)tz)).write(out, false);
                }
                if (res.last != null) {
                    obj.initAbstime("end", BAbsTime.make((BAbsTime)res.last.getTimestamp(), (BTimeZone)tz)).write(out, false);
                } else if (end != null) {
                    obj.initAbstime("end", BAbsTime.make((BAbsTime)end, (BTimeZone)tz)).write(out, false);
                }
                BHistoryRecord def = res.first;
                if (def == null) {
                    def = res.last;
                }
                boolean wasContract = out.isContract();
                if (def != null) {
                    out.setHref("#RecordDef");
                    out.setEncodeIs(true);
                    out.setEncodeFacets(true);
                    out.setContract(true);
                    BFacets withTZ = BFacets.make((BFacets)valueFacets, (String)"TimeZone", (BIDataValue)tz);
                    out.encode(new ObixTarget(base, (BObject)def, withTZ));
                }
                out.setContract(wasContract);
                obj.reset().endElem(out);
            }
        }
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        BInteger limit = BInteger.MAX;
        BAbsTime start = null;
        BAbsTime end = null;
        try {
            BComponent filter = (BComponent)in.decode();
            if (filter != null) {
                limit = (BInteger)filter.get("limit");
                start = (BAbsTime)filter.get("start");
                end = (BAbsTime)filter.get("end");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        Obj obj = new Obj().setIs("obix:HistoryQueryOut");
        obj.setHref(out.getHref());
        obj.write(out, true);
        obj.initList("data", "#RecordDef obix:HistoryRecord").write(out, true);
        out.commit();
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
            BITable results = conn.timeQuery(this.history, start, end);
            OrdTarget base = this.history.getOrdInSession().resolve(null, (Context)in);
            out.setName(null);
            out.setHref(null);
            out.setEncodeIs(false);
            BFacets valueFacets = (BFacets)this.history.getConfig().get("valueFacets");
            if (valueFacets == null) {
                valueFacets = BFacets.DEFAULT;
            }
            BTimeZone tz = this.history.getConfig().getTimeZone();
            BObixHistoryAgent.QueryResults res = BObixHistoryAgent.iterateQueryResults(out, (BITable<BHistoryRecord>)results, limit, base, tz);
            obj.initList(null, null).endElem(out);
            obj.initInt("count", res.count).write(out, false);
            if (res.first != null) {
                obj.initAbstime("start", BAbsTime.make((BAbsTime)res.first.getTimestamp(), (BTimeZone)tz)).write(out, false);
            } else if (start != null) {
                obj.initAbstime("start", BAbsTime.make((BAbsTime)start, (BTimeZone)tz)).write(out, false);
            }
            if (res.last != null) {
                obj.initAbstime("end", BAbsTime.make((BAbsTime)res.last.getTimestamp(), (BTimeZone)tz)).write(out, false);
            } else if (end != null) {
                obj.initAbstime("end", BAbsTime.make((BAbsTime)end, (BTimeZone)tz)).write(out, false);
            }
            BHistoryRecord def = res.first;
            if (def == null) {
                def = res.last;
            }
            boolean wasContract = out.isContract();
            if (def != null) {
                out.setHref("#RecordDef");
                out.setEncodeIs(true);
                out.setEncodeFacets(true);
                out.setContract(true);
                BFacets withTZ = BFacets.make((BFacets)valueFacets, (String)"TimeZone", (BIDataValue)tz);
                out.encode(new ObixTarget(base, (BObject)def, withTZ));
            }
            out.setContract(wasContract);
            obj.reset().endElem(out);
        }
    }
}

