/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BObixAbout
extends BObixAgent
implements BIObixLobbyAgent,
ObixConstants {
    public static final Property obixVersion = BObixAbout.newProperty((int)257, (String)"1.0", null);
    public static final Property serverName = BObixAbout.newProperty((int)257, (String)BObixAbout.serverName(), null);
    public static final Property serverTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    public static final Property serverBootTime = BObixAbout.newProperty((int)257, (BValue)Clock.time(), null);
    public static final Property vendorName = BObixAbout.newProperty((int)257, (String)"Tridium, Inc.", null);
    public static final Property vendorUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    public static final Property productName = BObixAbout.newProperty((int)257, (String)"Niagara AX", null);
    public static final Property productVersion = BObixAbout.newProperty((int)257, (String)BObixAbout.version(), null);
    public static final Property productUrl = BObixAbout.newProperty((int)257, (BValue)BOrd.make((String)"http://www.tridium.com"), null);
    public static final Property tz = BObixAbout.newProperty((int)257, (String)BObixAbout.tz(), null);
    public static final Property componentCount = BObixAbout.newProperty((int)261, (String)BObixAbout.componentCount(), null);
    public static final Property localHistoryCount = BObixAbout.newProperty((int)261, (String)BObixAbout.localHistoryCount(), null);
    public static final Type TYPE = Sys.loadType(BObixAbout.class);

    public String getObixVersion() {
        return this.getString(obixVersion);
    }

    public void setObixVersion(String v) {
        this.setString(obixVersion, v, null);
    }

    public String getServerName() {
        return this.getString(serverName);
    }

    public void setServerName(String v) {
        this.setString(serverName, v, null);
    }

    public BAbsTime getServerTime() {
        return (BAbsTime)this.get(serverTime);
    }

    public void setServerTime(BAbsTime v) {
        this.set(serverTime, (BValue)v, null);
    }

    public BAbsTime getServerBootTime() {
        return (BAbsTime)this.get(serverBootTime);
    }

    public void setServerBootTime(BAbsTime v) {
        this.set(serverBootTime, (BValue)v, null);
    }

    public String getVendorName() {
        return this.getString(vendorName);
    }

    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    public BOrd getVendorUrl() {
        return (BOrd)this.get(vendorUrl);
    }

    public void setVendorUrl(BOrd v) {
        this.set(vendorUrl, (BValue)v, null);
    }

    public String getProductName() {
        return this.getString(productName);
    }

    public void setProductName(String v) {
        this.setString(productName, v, null);
    }

    public String getProductVersion() {
        return this.getString(productVersion);
    }

    public void setProductVersion(String v) {
        this.setString(productVersion, v, null);
    }

    public BOrd getProductUrl() {
        return (BOrd)this.get(productUrl);
    }

    public void setProductUrl(BOrd v) {
        this.set(productUrl, (BValue)v, null);
    }

    public String getTz() {
        return this.getString(tz);
    }

    public void setTz(String v) {
        this.setString(tz, v, null);
    }

    public String getComponentCount() {
        return this.getString(componentCount);
    }

    public void setComponentCount(String v) {
        this.setString(componentCount, v, null);
    }

    public String getLocalHistoryCount() {
        return this.getString(localHistoryCount);
    }

    public void setLocalHistoryCount(String v) {
        this.setString(localHistoryCount, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeLobbyChild(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj();
            o.setHref(out.getHref());
            o.setName("about");
            o.setElement("ref");
            o.setIs("obix:About");
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    @Override
    public String getLobbyName() {
        return "about";
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return "obix:About";
        }
        return value;
    }

    @Override
    public OrdTarget resolve(String uri, Context cx) {
        this.setServerTime(Clock.time());
        try {
            BOrd o = BOrd.make((String)"station:");
            o = BOrd.make((BOrd)o, (BOrd)this.getSlotPathOrd());
            if (uri.equals("") || uri.equals("/")) {
                return o.resolve((BObject)Sys.getStation(), cx);
            }
            o = BOrd.make((BOrd)o, (String)("slot:" + uri.substring(1)));
            return o.resolve((BObject)Sys.getStation(), cx);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    private static String componentCount() {
        try {
            BStation s = Sys.getStation();
            if (s != null) {
                return "" + s.getComponentSpace().getComponentCount();
            }
            return "workbench";
        }
        catch (Exception x) {
            return x.toString();
        }
    }

    private static String localHistoryCount() {
        try {
            BHistoryService hs = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = hs.getDatabase();
            if (db instanceof BLocalHistoryDatabase) {
                BLocalHistoryDatabase ldb = (BLocalHistoryDatabase)db;
                TableCursor cur = ldb.cursor();
                int historyCount = 0;
                while (cur.next()) {
                    ++historyCount;
                }
                return "" + historyCount;
            }
            return "0";
        }
        catch (Exception x) {
            return x.toString();
        }
    }

    private static String serverName() {
        return Sys.getHostName();
    }

    private static String tz() {
        try {
            return BTimeZone.getLocal().getId();
        }
        catch (Exception x) {
            return x.getMessage();
        }
    }

    private static String version() {
        try {
            return Sys.getBajaVersion().toString();
        }
        catch (Exception x) {
            return x.getMessage();
        }
    }
}

