/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixStatusAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:ControlPoint"}, requiredPermissions="r")})
public class BControlPointAgent
extends BObixStatusAgent {
    public static final Type TYPE = Sys.loadType(BControlPointAgent.class);
    Obj val;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean encode(OrdTarget target, ObixEncoder out) throws Exception {
        super.encode(target, out);
        BControlPoint cp = (BControlPoint)target.get();
        String prop = cp.getOutProperty().getName();
        BOrd ord = BOrd.make((String)("slot:" + prop));
        OrdTarget outTarget = ord.resolve((BObject)cp, (Context)target);
        BStatusValue sv = (BStatusValue)outTarget.get();
        this.val = new Obj();
        String href = out.getHref();
        this.val.setName(out.getName());
        this.val.setHref(ObixUtils.makeSlotPathUri(out, ObixUtils.concat(cp.toPathString(), prop)));
        ObixUtils.encode(out, this.val, (BObject)sv.getValueValue(), outTarget);
        this.val.setHref(href);
        this.val.setStatus(BControlPointAgent.getStatus((BIStatus)sv.getStatus()));
        if (sv.getStatus().isNull()) {
            this.val.setNull(Boolean.TRUE);
        }
        if (out.isRef()) {
            this.val.makeRef();
        }
        return true;
    }

    @Override
    public String processAttr(String name, String value) {
        switch (name) {
            case "is": {
                return BIObixAgent.addToList(value, "obix:Point");
            }
            case "writable": {
                return null;
            }
            case "max": {
                return this.val.getMax();
            }
            case "min": {
                return this.val.getMin();
            }
            case "precision": {
                return this.val.getPrecision();
            }
            case "range": {
                return this.val.getRange();
            }
            case "unit": {
                return this.val.getUnits();
            }
            case "val": {
                return this.val.getVal();
            }
            case "status": {
                return this.val.getStatus();
            }
            case "null": {
                return this.val.isNull() ? "true" : value;
            }
        }
        return super.processAttr(name, value);
    }

    @Override
    public String processElem(String value) {
        return this.val.getElement();
    }
}

