/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService"}, requiredPermissions="r")})
public class BAlarmServiceAgent
extends BObixAgent {
    public static final Type TYPE = Sys.loadType(BAlarmServiceAgent.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public static void encodeAlarm(BAlarmRecord rec, ObixEncoder out, Obj obj, Context cx) {
        String[] keys;
        BObject val;
        obj.reset().setName(out.getName());
        obj.addContract("obix:Alarm obix:AckAlarm");
        String message = rec.getAlarmData().gets("msgText", null);
        if (message != null) {
            obj.setDisplay(message);
        }
        if ((val = rec.getAlarmValue()) != null) {
            obj.addContract("obix:PointAlarm");
        }
        if (rec.getAlarmTransition() != BSourceState.alert) {
            obj.addContract("obix:StatefulAlarm");
        }
        String href = null;
        try {
            href = ObixUtils.makeAlarmUri(out, rec.getUuid().encodeToString());
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        obj.setHref(href);
        obj.write(out, true);
        Array a = new Array(String.class);
        if (href != null) {
            obj.initOp("ack", "obix:AlarmAckIn", "obix:AlarmAckOut");
            obj.setHref(ObixUtils.concat(href, "ack"));
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        }
        boolean sourceWritten = false;
        BOrdList list = rec.getSource();
        if (list.size() > 0) {
            try {
                BOrd o = list.get(0);
                OrdTarget tgt = o.resolve((BObject)Sys.getStation(), cx);
                String path = ObixUtils.toPath(tgt);
                obj.initRef("source", ObixUtils.makeSlotPathUri(out, path));
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                sourceWritten = true;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        boolean alarmValueWritten = false;
        if (val != null && val.isSimple()) {
            try {
                ObixUtils.encodeSimple(out, obj.reset(), val.asSimple(), cx);
                obj.setName("alarmValue");
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                alarmValueWritten = true;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (rec.isAcknowledged() && !rec.getAckTime().isNull()) {
            obj.initAbstime("ackTimestamp", rec.getAckTime());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
            obj.initStr("ackUser", rec.getUser());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        }
        if (!rec.getNormalTime().isNull()) {
            obj.initAbstime("normalTimestamp", rec.getNormalTime());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        }
        obj.initAbstime("timestamp", rec.getTimestamp());
        BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        try {
            obj.initStr("niagara-uuid", rec.getUuid().encodeToString());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
            obj.initInt("priority", rec.getPriority());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
            obj.initStr("alarmClass", rec.getAlarmClass());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
        BFacets alarmData = rec.getAlarmData();
        for (String k : keys = alarmData.list()) {
            BObject value = alarmData.get(k);
            if ("alarmValue".equals(k) && alarmValueWritten) continue;
            if ("source".equals(k) && sourceWritten) {
                obj.initStr("originalSource", value.toString());
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            if ("priority".equals(k)) {
                obj.initInt("originalPriority", Integer.parseInt(value.toString()));
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            if ("alarmClass".equals(k)) {
                obj.initStr("originalAlarmClass", value.toString());
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            if (value instanceof BBoolean) {
                obj.initBool(k, ((BBoolean)value).getBoolean());
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            if (value instanceof BDouble) {
                obj.initReal(k, ((BDouble)value).getDouble());
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            if (value instanceof BInteger) {
                obj.initInt(k, ((BInteger)value).getInt());
                BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
                continue;
            }
            obj.initStr(k, value.toString());
            BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        }
        obj.initStr("sourceStation", Sys.getStation().getStationName());
        BAlarmServiceAgent.safeWrite((Array<String>)a, obj, out);
        obj.reset().endElem(out);
    }

    private static void safeWrite(Array<String> a, Obj obj, ObixEncoder out) {
        String name = obj.getName();
        if (!a.contains((Object)name)) {
            a.add((Object)name);
            obj.write(out, false);
        } else if (out.isDebug()) {
            System.out.println("obj '" + obj + "' not written: duplicate element!");
        }
    }

    @Override
    public void encodeFinishing() throws Exception {
        super.encodeFinishing();
        ObixEncoder out = this.getEncoder();
        String href = out.getHref();
        Obj obj = new Obj();
        BAlarmService service = (BAlarmService)this.getTarget().get();
        BAlarmDatabase db = service.getAlarmDb();
        if (db != null) {
            int count = 0;
            try (AlarmDbConnection conn = db.getDbConnection(null);
                 Cursor c = conn.getOpenAlarms();){
                while (c.next()) {
                    ++count;
                }
            }
            obj.initInt("count", count).setMin(String.valueOf(0));
        } else {
            obj.initInt("count", 0).setMin(String.valueOf(0));
        }
        obj.write(out, false);
        obj.initOp("query", "obix:AlarmFilter", "obix:AlarmQueryOut");
        obj.setHref(out.getChildHref(href, "~alarmQuery"));
        obj.write(out, false);
        obj.initFeed("feed", "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(out.getChildHref(href, "~alarmFeed"));
        obj.write(out, false);
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return BIObixAgent.addToList(value, "obix:AlarmSubject");
        }
        return value;
    }

    static IterationResults iterateResults(BInteger limit, BITable<BAlarmRecord> results, Obj obj, ObixEncoder out, Context cx) {
        int count = 0;
        BAbsTime first = null;
        BAbsTime last = null;
        int max = Integer.MAX_VALUE;
        if (limit != null) {
            max = limit.getInt();
        }
        BAlarmRecord rec = null;
        TableCursor cur = results.cursor();
        if (cur.next()) {
            rec = (BAlarmRecord)cur.get();
        }
        if (rec != null) {
            last = first = rec.getLastUpdate();
        }
        while (count < max && rec != null) {
            if (last.isBefore(rec.getLastUpdate())) {
                last = rec.getLastUpdate();
            }
            BAlarmServiceAgent.encodeAlarm(rec, out, obj.reset(), cx);
            out.commit();
            ++count;
            if (cur.next()) {
                rec = (BAlarmRecord)cur.get();
                continue;
            }
            rec = null;
        }
        IterationResults ret = new IterationResults();
        ret.count = count;
        ret.first = first;
        ret.last = last;
        return ret;
    }

    static String queryChanges(BAbsTime start, BAbsTime end, BAlarmClass ac) {
        StringBuilder buf = new StringBuilder("alarm:|bql:select *");
        boolean where = false;
        if (ac != null) {
            where = true;
            buf.append(" where");
            buf.append(" alarmClass = '").append(ac.getName()).append('\'');
        }
        if (start != null && !start.isNull()) {
            if (!where) {
                where = true;
                buf.append(" where");
            } else {
                buf.append(" and");
            }
            buf.append(" lastUpdate > '");
            buf.append(start.encodeToString()).append('\'');
        }
        if (end != null && !end.isNull()) {
            if (!where) {
                buf.append(" where");
            } else {
                buf.append(" and");
            }
            buf.append(" lastUpdate <= '").append(end.encodeToString()).append('\'');
        }
        return buf.toString();
    }

    static String queryRefresh(BAbsTime start, BAbsTime end, BAlarmClass ac) {
        StringBuilder buf = new StringBuilder("alarm:|bql:select * from openAlarms");
        boolean where = false;
        if (ac != null) {
            where = true;
            buf.append(" where");
            buf.append(" alarmClass = '").append(ac.getName()).append('\'');
        }
        if (start != null && !start.isNull()) {
            if (!where) {
                where = true;
                buf.append(" where");
            } else {
                buf.append(" and");
            }
            buf.append(" lastUpdate >= '");
            buf.append(start.encodeToString()).append('\'');
        }
        if (end != null && !end.isNull()) {
            if (!where) {
                buf.append(" where");
            } else {
                buf.append(" and");
            }
            buf.append(" lastUpdate <= '").append(end.encodeToString()).append('\'');
        }
        return buf.toString();
    }

    static class IterationResults {
        int count;
        BAbsTime first;
        BAbsTime last;

        IterationResults() {
        }
    }
}

