/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BAlarmWrapper;
import com.tridium.obix.util.BadUriErr;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BAlarmLobbyAgent
extends BObject
implements BIObixLobbyAgent {
    public static final Type TYPE = Sys.loadType(BAlarmLobbyAgent.class);
    public static String LOBBY_NAME = "alarm";
    public BAlarmDatabase db = null;
    public BAlarmService service = null;

    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeLobbyChild(ObixEncoder out, Context cx) {
    }

    @Override
    public String getLobbyName() {
        return LOBBY_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OrdTarget resolve(String uri, Context cx) {
        try {
            int i = uri.indexOf(47, 1);
            String uuid = null;
            boolean ack = false;
            if (i > 0) {
                uuid = uri.substring(1, i);
                ack = (uri = uri.substring(i)).indexOf("ack") >= 0;
            } else {
                uuid = uri.substring(1);
            }
            BUuid uid = (BUuid)BUuid.DEFAULT.decodeFromString(uuid);
            BAlarmDatabase db = this.getDb();
            try (AlarmDbConnection conn = db.getDbConnection(null);){
                BAlarmRecord rec = conn.getRecord(uid);
                if (rec == null) {
                    throw new BadUriErr("UUID not found: " + uuid);
                }
                BOrd o = BOrd.make((String)"alarm:");
                OrdTarget ot = o.resolve((BObject)Sys.getStation(), cx);
                ObixTarget obixTarget = new ObixTarget(ot, new BAlarmWrapper(rec, ack));
                return obixTarget;
            }
        }
        catch (Exception x) {
            throw new BadUriErr();
        }
    }

    private BAlarmDatabase getDb() {
        if (this.db == null) {
            this.service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            this.db = this.service.getAlarmDb();
        }
        return this.db;
    }
}

