/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.Obj;
import javax.baja.alarm.BAlarmClass;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmClass"}, requiredPermissions="r")})
public class BAlarmClassAgent
extends BObixAgent {
    public static final Type TYPE = Sys.loadType(BAlarmClassAgent.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeFinishing() throws Exception {
        super.encodeFinishing();
        ObixEncoder out = this.getEncoder();
        String href = out.getHref();
        Obj obj = new Obj();
        BAlarmClass ac = (BAlarmClass)this.getTarget().get();
        obj.initInt("count", ac.getOpenAlarmCount()).setMin(String.valueOf(0));
        obj.write(out, false);
        obj.initOp("query", "obix:AlarmFilter", "obix:AlarmQueryOut");
        obj.setHref(out.getChildHref(href, "~alarmQuery"));
        obj.write(out, false);
        obj.initFeed("feed", "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(out.getChildHref(href, "~alarmFeed"));
        obj.write(out, false);
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return BIObixAgent.addToList(value, "obix:AlarmSubject");
        }
        return value;
    }
}

