/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.naming;

import com.tridium.obix.util.ObixUtils;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.Path;

public class ObixQuery
implements OrdQuery,
Path {
    String body;
    String[] names;

    public ObixQuery(String body) {
        this(body, null);
    }

    public ObixQuery(String body, String[] names) {
        this.body = body;
        this.names = names;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList list, int index) {
    }

    public String getScheme() {
        return "obix";
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        return "obix:" + this.body;
    }

    public int depth() {
        this.check();
        return this.names.length;
    }

    public String[] getNames() {
        this.check();
        return this.names;
    }

    public Path getParentPath() {
        this.check();
        StringBuffer buf = new StringBuffer();
        int len = this.names.length - 1;
        for (int i = 0; i < len; ++i) {
            buf.append('/').append(this.names[i]);
        }
        if (buf.length() == 0) {
            return null;
        }
        return new ObixQuery(buf.toString());
    }

    public String nameAt(int depth) {
        this.check();
        return this.names[depth];
    }

    private void check() {
        if (this.names == null) {
            this.names = ObixUtils.toPathArray(this.body);
        }
    }
}

