/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.naming;

import com.tridium.obix.naming.BIObixScheme;
import com.tridium.obix.naming.ObixQuery;
import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.util.ObixUtils;
import java.util.HashMap;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(ordScheme="obix")
public class BObixOrdScheme
extends BOrdScheme {
    public static final BObixOrdScheme INSTANCE = new BObixOrdScheme();
    public static final Type TYPE = Sys.loadType(BObixOrdScheme.class);
    protected static HashMap<String, BIObixScheme> schemes;

    public Type getType() {
        return TYPE;
    }

    private BObixOrdScheme() {
        super("obix");
    }

    public OrdQuery parse(String body) {
        return new ObixQuery(body, ObixUtils.toPathArray(body));
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery ordQuery) {
        ObixQuery query = (ObixQuery)ordQuery;
        base = new ObixTarget(base, null);
        String path = query.getBody();
        if ("/".equals(path) || path.isEmpty()) {
            return base;
        }
        String name = query.nameAt(0);
        int qMark = name.indexOf(63);
        if (qMark >= 0) {
            name = name.substring(0, qMark);
        }
        String def = Sys.getRegistry().getDef("obix.scheme." + name);
        BIObixScheme sch = this.getScheme(def);
        try {
            base = sch.resolve(base, query);
        }
        catch (UnresolvedException ux) {
            throw new UnresolvedException("Cannot resolve " + query.getBody());
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BIObixScheme getScheme(String def) {
        try {
            BIObixScheme ret;
            if (schemes != null && (ret = schemes.get(def)) != null) {
                return ret;
            }
            BTypeSpec spec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(def);
            ret = (BIObixScheme)spec.getInstance();
            if (!ret.isCachable()) return ret;
            Class<BObixOrdScheme> clazz = BObixOrdScheme.class;
            synchronized (BObixOrdScheme.class) {
                if (schemes == null) {
                    schemes = new HashMap();
                }
                schemes.put(def, ret);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return ret;
            }
        }
        catch (Exception x) {
            throw new SyntaxException("Invalid subscheme: " + def, (Throwable)x);
        }
    }
}

