/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.naming;

import com.tridium.obix.naming.BIObixScheme;
import com.tridium.obix.naming.BObixOrdScheme;
import com.tridium.obix.naming.ObixQuery;
import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BObixHistoryAppend;
import com.tridium.obix.server.BObixHistoryFeed;
import com.tridium.obix.server.BObixHistoryQuery;
import com.tridium.obix.server.BObixHistoryRollup;
import com.tridium.obix.util.BadUriErr;
import javax.baja.history.BIHistory;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BObixHistoryScheme
extends BObject
implements BIObixScheme {
    public static final Type TYPE = Sys.loadType(BObixHistoryScheme.class);

    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) {
        BObject o = base.get();
        if (o instanceof BIHistory) {
            BIHistory his = (BIHistory)base.get();
            ObixQuery q = (ObixQuery)query;
            String s = q.nameAt(0);
            if ("historyFeed".equals(s)) {
                return new ObixTarget(base, new BObixHistoryFeed(his));
            }
            if (s.startsWith("historyQuery")) {
                return new ObixTarget(base, new BObixHistoryQuery(his, query));
            }
            if ("historyRollup".equals(s)) {
                return new ObixTarget(base, new BObixHistoryRollup(his));
            }
            if ("historyAppend".equals(s)) {
                return new ObixTarget(base, new BObixHistoryAppend(his, query));
            }
            throw new BadUriErr();
        }
        ObixQuery q = (ObixQuery)query;
        String s = q.nameAt(0);
        String def = Sys.getRegistry().getDef("obix.scheme." + s + '.' + o.getType());
        BIObixScheme scheme = BObixOrdScheme.INSTANCE.getScheme(def);
        if (scheme != null) {
            return scheme.resolve(base, query);
        }
        throw new BadUriErr();
    }
}

