/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixPointDiscoveryJob;
import com.tridium.obix.driver.point.BObixPointDiscoveryResult;
import com.tridium.obix.driver.point.BR2PointDeviceExt;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Contract;
import obix.Obj;
import obix.Uri;

public class BR2PointDiscoveryJob
extends BObixPointDiscoveryJob {
    public static final Type TYPE = Sys.loadType(BR2PointDiscoveryJob.class);
    private static Uri INTERNAL_PROP_URI = new Uri("t:InternalProp");
    private static Uri UI_NODE_URI = new Uri("t:UiNode");
    protected BR2PointDeviceExt r2Ext;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BR2PointDiscoveryJob() {
    }

    public BR2PointDiscoveryJob(BR2PointDeviceExt ext, BValue uri) {
        super(ext, uri);
        this.r2Ext = ext;
    }

    @Override
    protected boolean checkAddRef(Obj ref) {
        Uri uri = ref.getNormalizedHref();
        if (uri == null) {
            return false;
        }
        Contract c = ref.getIs();
        if (c != null && c.contains(UI_NODE_URI)) {
            return this.r2Ext.getIncludeUiNodes();
        }
        return true;
    }

    @Override
    protected boolean checkAddResult(BObixPointDiscoveryResult pr, Obj res) {
        if (pr == null) {
            return false;
        }
        Contract c = res.getIs();
        if (c != null && c.contains(INTERNAL_PROP_URI)) {
            return this.r2Ext.getIncludeInternalProps();
        }
        return true;
    }
}

