/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history;

import com.tridium.history.SchemaChangeException;
import com.tridium.obix.driver.history.ArchiveInvocation;
import com.tridium.obix.driver.history.BObixHistoryDeviceExt;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import obix.Abstime;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Str;
import obix.Uri;

public class BObixHistoryImport
extends BHistoryImport
implements BIStatus {
    public static final Property href = BObixHistoryImport.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BObixHistoryImport.class);
    private BObixHistoryDeviceExt deviceExt = null;
    private boolean firstExecute = true;
    private boolean licenseChecked = false;
    private boolean fatalFault = false;
    private String fatalFaultCause = null;
    private String recordInfo = null;

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String v) {
        this.setString(href, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                @Override
                public void run() {
                    BObixHistoryImport.this.checkObixLicense();
                }
            });
        }
        this.hImportAtSteadyState();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled) && !this.isDisabled()) {
            this.checkObixLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        if (this.fatalFault) {
            this.executeFail(this.fatalFaultCause);
            return;
        }
        if (this.getHistoryId().isNull()) {
            this.executeFail("History id is null.");
            return;
        }
        this.executeInProgress();
        Str results = new Str("empty");
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.executeFail("Local history database not available.");
                return;
            }
            BHistoryId id = this.getHistoryId().fromShorthand(this.getObixClient().getName());
            BIHistory history = null;
            BAbsTime lastTimestamp = null;
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                String recInfo;
                String resultsPath;
                if (conn.exists(id)) {
                    history = conn.getHistory(id);
                    lastTimestamp = conn.getLastTimestamp(history);
                }
                Obj query = new Obj();
                String reqHref = this.getHref();
                if (!reqHref.endsWith("/")) {
                    reqHref = reqHref + "/";
                }
                query.setIs(new Contract("obix:HistoryFilter"));
                if (lastTimestamp != null) {
                    query.add((Obj)new Abstime("start", lastTimestamp.getMillis() + 1L));
                }
                if (!(resultsPath = (results = this.getObixClient().obixInvoke(new Uri(reqHref), query)).getHref().getPath()).equals("/") && !results.getHref().getPath().endsWith(reqHref)) {
                    this.getLogger().fine("Mismatch: returned href [" + results.getHref().getPath() + "] doesn't equal requested href [" + reqHref + "]\n");
                    this.executeFail("Mismatch: respHref != reqHref");
                    return;
                }
                Obj oRecInfo = results.get("recInfo");
                String string = recInfo = oRecInfo != null ? oRecInfo.getStr() : null;
                if (this.recordInfo != null && !recInfo.equals(this.recordInfo)) {
                    this.getLogger().fine("Record type mismatch on " + (Object)((Object)this) + " (id=" + id + ") [" + this.getHref() + "]: Incoming record info " + recInfo + " does not match current record info " + this.recordInfo);
                    this.executeFail("Record Type mismatch");
                    this.recordInfo = recInfo;
                    return;
                }
                this.recordInfo = recInfo;
                Obj list = results.get("data");
                Obj[] records = list.list();
                int len = records.length;
                if (records == null || len == 0) {
                    this.executeOk();
                    return;
                }
                BHistoryConfig config = new BHistoryConfig();
                config.setId(id);
                this.updateConfig((Obj)results, config);
                BFacets facets = (BFacets)this.getConfigOverrides().get("valueFacets");
                if (this.firstExecute) {
                    this.firstExecute = false;
                    if (facets != null) {
                        BUnit unit;
                        BEnumRange range;
                        BFacets boolFacets;
                        String uri = facets.gets("boolUri", null);
                        if (uri != null && (boolFacets = this.getObixClient().makeBoolRange(new Uri(uri))) != null) {
                            facets = BFacets.make((BFacets)facets, (BFacets)boolFacets);
                        }
                        if ((uri = facets.gets("enumUri", null)) != null && (range = this.getObixClient().makeEnumRange(new Uri(uri))) != null) {
                            facets = BFacets.make((BFacets)facets, (String)"range", (BIDataValue)range);
                        }
                        if ((uri = facets.gets("unitsUri", null)) != null && (unit = this.getObixClient().makeUnits(new Uri(uri))) != null) {
                            facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit);
                        }
                    }
                    this.getConfigOverrides().set("valueFacets", (BValue)facets);
                }
                config = this.makeLocalConfig(config);
                if (history == null) {
                    try {
                        this.getLogger().fine("Creating db history for href " + this.getHref() + " with config:" + config + " {id=" + config.getId() + "; rectype=" + config.getRecordType() + "; schema=" + config.getSchema() + "}");
                        try {
                            this.getLogger().fine("current config type:" + conn.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + conn.getHistory(this.getHistoryId()).getConfig().getSchema());
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Cannot show old config type:" + e);
                        }
                        try {
                            this.getLogger().fine("new config type:" + config.getRecordType() + "; schema=" + config.getSchema());
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Cannot show old config type:" + e);
                        }
                        conn.createHistory(config);
                        history = conn.getHistory(id);
                    }
                    catch (SchemaChangeException sce) {
                        this.getLogger().log(Level.FINE, "SchemaChangeException for href " + this.getHref() + " [id=" + this.getHistoryId() + "]" + (Object)((Object)sce), sce);
                        try {
                            this.getLogger().fine("current config type:" + conn.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + conn.getHistory(this.getHistoryId()).getConfig().getSchema());
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Cannot show old config type:" + e);
                        }
                        try {
                            this.getLogger().fine("new config type:" + config.getRecordType() + "; schema=" + config.getSchema());
                        }
                        catch (Exception e) {
                            this.getLogger().fine("Cannot show old config type:" + e);
                        }
                        throw sce;
                    }
                }
                boolean configchange = true;
                try {
                    if (conn.getHistory(this.getHistoryId()).getConfig().getRecordType().equals((Object)config.getRecordType())) {
                        configchange = false;
                    }
                }
                catch (Exception e) {
                    this.getLogger().fine("Check history config for oBIX history import on " + this.getHref() + ": Could not determine config change:" + e);
                }
                if (configchange && this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("Reconfigure history for href " + this.getHref() + " [id=" + this.getHistoryId() + "]; resp href=" + results.getHref().getPath());
                    this.getLogger().fine("response data:" + list);
                    list.dump();
                    this.getLogger().fine("response data:" + list);
                    list.dump();
                    try {
                        this.getLogger().fine("current config type:" + conn.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + conn.getHistory(this.getHistoryId()).getConfig().getSchema());
                    }
                    catch (Exception e) {
                        this.getLogger().fine("Cannot show old config type:" + e);
                    }
                    try {
                        this.getLogger().fine("new config type:" + config.getRecordType() + "; schema=" + config.getSchema());
                    }
                    catch (Exception e) {
                        this.getLogger().fine("Cannot show old config type:" + e);
                    }
                }
                conn.reconfigureHistory(config);
                BTimeZone tz = null;
                for (int i = 0; i < len; ++i) {
                    Obj record = records[i];
                    BHistoryRecord rec = config.makeRecord();
                    Abstime ts = (Abstime)record.get("timestamp");
                    if (ts != null) {
                        TimeZone jtz;
                        if (tz == null && (tz = BTimeZone.getTimeZone((String)(jtz = ts.getTimeZone()).getID())) == null) {
                            tz = BTimeZone.make((String)jtz.getID(), (int)jtz.getRawOffset());
                        }
                        rec.setTimestamp(BAbsTime.make((long)ts.getMillis(), tz));
                    }
                    Obj val = record.get("value");
                    BStatusValue sv = this.getObixClient().makeStatusValue(val, facets);
                    rec.set("status", (BValue)sv.getStatus());
                    rec.set("value", sv.getValueValue());
                    conn.append(history, (BIHistoryRecordSet)rec);
                }
                this.executeOk();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error importing history for href " + this.getHref() + " in " + (Object)((Object)this.getObixClient()), e);
            this.executeFail(e);
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("results");
                results.dump();
            }
        }
    }

    public Type getDeviceExtType() {
        return BObixHistoryDeviceExt.TYPE;
    }

    public Logger getLogger() {
        return this.getObixHistoryDeviceExt().getLogger();
    }

    public BObixClient getObixClient() {
        return this.getObixHistoryDeviceExt().getObixClient();
    }

    public BObixHistoryDeviceExt getObixHistoryDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BObixHistoryDeviceExt)) continue;
            this.deviceExt = (BObixHistoryDeviceExt)p;
            return this.deviceExt;
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == BDescriptor.execute) {
            if (this.fatalFault || this.isFatalFault() || this.isDisabled()) {
                return null;
            }
            if (this.isDown()) {
                this.executeFail("Device is down");
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    public IFuture postExecute(Action a, BValue arg, Context cx) {
        return this.getObixHistoryDeviceExt().post(new ArchiveInvocation(this, a, arg, cx));
    }

    public void stopped() throws Exception {
        this.setStatus(BStatus.down);
        this.deviceExt = null;
        super.stopped();
    }

    protected void hImportAtSteadyState() throws Exception {
    }

    void updateConfig(Obj results, BHistoryConfig config) {
        Uri uri;
        List list = (List)results.get("data");
        Contract of = list.getOf();
        Obj proto = null;
        int i = of.size();
        while (!(--i < 0 || (uri = of.get(i)).isResolved() && (proto = uri.getResolved().get("value")) != null)) {
        }
        Obj[] records = list.list();
        Obj record = null;
        if (records.length > 0) {
            TimeZone jtz;
            record = records[0];
            Abstime ts = (Abstime)record.get("timestamp");
            BTimeZone btz = null;
            if (ts != null && (btz = BTimeZone.getTimeZone((String)(jtz = ts.getTimeZone()).getID())) == null) {
                btz = BTimeZone.make((String)jtz.getID(), (int)jtz.getRawOffset());
            }
            if (btz == null) {
                btz = BTimeZone.getLocal();
            }
            config.setTimeZone(btz);
        }
        if (proto == null && record != null) {
            proto = record.get("value");
        }
        if (proto != null) {
            BFacets facets = this.getObixClient().makeFacets(BFacets.DEFAULT, proto);
            BFacets base = (BFacets)this.getConfigOverrides().get("valueFacets");
            if (base == null) {
                this.getConfigOverrides().add("valueFacets", (BValue)facets);
            } else {
                facets = BFacets.make((BFacets)base, (BFacets)facets);
                this.getConfigOverrides().set("valueFacets", (BValue)facets);
            }
            if (proto.isBool()) {
                config.setRecordType(BBooleanTrendRecord.TYPE.getTypeSpec());
            } else if (proto.isEnum()) {
                config.setRecordType(BEnumTrendRecord.TYPE.getTypeSpec());
            } else if (proto.isInt() || proto.isReal() || proto.isReltime()) {
                config.setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
            } else {
                config.setRecordType(BStringTrendRecord.TYPE.getTypeSpec());
            }
        }
    }

    private void checkObixLicense() {
        String licenseFault;
        if (this.licenseChecked) {
            return;
        }
        Boolean isTridium = this.getObixClient().isTridiumServer();
        if (isTridium == null) {
            return;
        }
        if (!isTridium.booleanValue() && (licenseFault = this.getObixNetwork().checkObixLimit("foreignHistory.limit")) != null) {
            this.configFatal(licenseFault);
        }
        this.licenseChecked = true;
    }

    private void configFatal(String ffc) {
        this.fatalFault = true;
        this.fatalFaultCause = ffc;
        this.executeFail(ffc);
    }
}

