/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history;

import com.tridium.obix.driver.history.ArchiveInvocation;
import com.tridium.obix.driver.history.BObixHistoryDiscoveryJob;
import com.tridium.obix.driver.history.BObixHistoryImport;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="retryDelay", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(0)", flags=4), @NiagaraProperty(name="retryGroupSize", type="int", defaultValue="Integer.MAX_VALUE", flags=4, facets={@Facet(name="BFacets.MIN", value="0")})})
@NiagaraActions(value={@NiagaraAction(name="getClient", flags=4, returnType="baja:Ord"), @NiagaraAction(name="submitHistoryDiscoveryJob", flags=4, returnType="baja:Ord")})
public class BObixHistoryDeviceExt
extends BHistoryDeviceExt {
    public static final Property retryDelay = BObixHistoryDeviceExt.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property retryGroupSize = BObixHistoryDeviceExt.newProperty((int)4, (int)Integer.MAX_VALUE, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Action getClient = BObixHistoryDeviceExt.newAction((int)4, null);
    public static final Action submitHistoryDiscoveryJob = BObixHistoryDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BObixHistoryDeviceExt.class);
    private boolean attached;
    private Logger log;
    private long lastArchiveTicks;
    private int groupCount;

    public BRelTime getRetryDelay() {
        return (BRelTime)this.get(retryDelay);
    }

    public void setRetryDelay(BRelTime v) {
        this.set(retryDelay, (BValue)v, null);
    }

    public int getRetryGroupSize() {
        return this.getInt(retryGroupSize);
    }

    public void setRetryGroupSize(int v) {
        this.setInt(retryGroupSize, v, null);
    }

    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    public BOrd submitHistoryDiscoveryJob() {
        return (BOrd)this.invoke(submitHistoryDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void attach() {
        this.attached = true;
    }

    public void detach() {
        this.attached = false;
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    public BOrd doSubmitHistoryDiscoveryJob(Context cx) {
        return new BObixHistoryDiscoveryJob(this, this.getObixClient().get("lobby")).submit(cx);
    }

    public Type getImportDescriptorType() {
        return BObixHistoryImport.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public Logger getLogger() {
        if (this.log == null) {
            try {
                this.log = Logger.getLogger(this.getObixClient().getLogger().getName() + "-Histories");
            }
            catch (Exception x) {
                this.log = this.getObixClient().getLogger();
            }
        }
        return this.log;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    IFuture post(Invocation i) {
        BObixHistoryImport imp;
        if (i instanceof ArchiveInvocation && (imp = ((ArchiveInvocation)i).getHistoryImport()).getStatus().isFault()) {
            long archiveOkTime;
            long now = Clock.ticks();
            if (now > (archiveOkTime = this.lastArchiveTicks + this.getRetryDelay().getMillis())) {
                this.getObixNetwork().enqueue((Runnable)i);
                this.lastArchiveTicks = now;
                this.groupCount = 1;
            } else {
                int groupSize = this.getRetryGroupSize();
                if (this.groupCount < groupSize) {
                    this.getObixNetwork().enqueue((Runnable)i);
                    ++this.groupCount;
                } else {
                    this.getLogger().fine("Skipping import of " + imp.getName() + " due to retry delay (now=" + now + "; waiting until " + archiveOkTime + ')');
                    imp.setState(BDescriptorState.idle);
                }
            }
            return null;
        }
        this.getObixNetwork().enqueue((Runnable)i);
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("ObixHistoryDeviceExt");
        out.prop((Object)"attached", this.attached);
        out.prop((Object)"lastArchiveTicks", (double)this.lastArchiveTicks);
        out.prop((Object)"groupCount", this.groupCount);
        out.endProps();
        super.spy(out);
    }
}

