/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm;

import com.tridium.obix.driver.alarm.BObixAlarmDeviceExt;
import com.tridium.obix.driver.alarm.BObixAlarmDiscoveryResult;
import com.tridium.obix.driver.util.BObixDiscoveryJob;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

public class BObixAlarmDiscoveryJob
extends BObixDiscoveryJob {
    public static final Action fetch = BObixAlarmDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BObixAlarmDiscoveryJob.class);
    private static Uri lobby = new Uri("obix:Lobby");
    private static Uri alarmSubject = new Uri("obix:AlarmSubject");
    protected BValue uri;
    protected BObixAlarmDeviceExt ext;

    public BObixAlarmDiscoveryResult fetch(BString arg) {
        return (BObixAlarmDiscoveryResult)this.invoke(fetch, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BObixAlarmDiscoveryJob() {
    }

    public BObixAlarmDiscoveryJob(BObixAlarmDeviceExt ext, BValue uri) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.uri = uri;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixAlarmDiscoveryResult res = this.read(this.uri.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixAlarmDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixAlarmDiscoveryResult getResult() {
        return (BObixAlarmDiscoveryResult)this.get("result");
    }

    protected BObixAlarmDiscoveryResult read(String href, Context cx) throws Exception {
        BObixClient client = this.ext.getObixClient();
        Obj obj = client.obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixAlarmDiscoveryResult result(Obj obj) throws Exception {
        Obj feed;
        BObixClient client = this.ext.getObixClient();
        boolean isFeed = false;
        BObixAlarmDiscoveryResult res = new BObixAlarmDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(lobby)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null && obj.getIs().contains(alarmSubject) && (feed = obj.get("feed")) != null && feed.getHref() != null) {
            res.setFeed(client.getRelativeUri(feed.getNormalizedHref()).get());
            isFeed = true;
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (int i = 0; i < kids.length; ++i) {
            BObixAlarmDiscoveryResult ar;
            if (kids[i].isOp() || kids[i].isFeed()) continue;
            String name = kids[i].getName();
            if (name == null || name.equals("")) {
                name = kids[i].getDisplayName();
            }
            if (name == null || name.equals("")) {
                name = kids[i].getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kids[i].isRef()) {
                Uri uri = kids[i].getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kids[i].getHref() == null || (ar = this.result(kids[i])) == null) continue;
            children.add(name, (BValue)ar);
            ++count;
        }
        if (count == 0 && !isFeed) {
            return null;
        }
        return res;
    }
}

