/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm;

import com.tridium.obix.driver.alarm.BObixAlarmDiscoveryJob;
import com.tridium.obix.driver.alarm.BObixAlarmImport;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Obj;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.SessionWatch;
import obix.net.WatchListener;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", flags=6, facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassEditor\")")}, override=true), @NiagaraProperty(name="watchInterval", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(2)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="watchUri", type="String", defaultValue="", flags=3), @NiagaraProperty(name="debugWatch", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="getClient", returnType="baja:Ord", flags=4), @NiagaraAction(name="submitAlarmDiscoveryJob", returnType="baja:Ord", flags=4), @NiagaraAction(name="subscribe", flags=20)})
public class BObixAlarmDeviceExt
extends BAlarmDeviceExt
implements WatchListener {
    public static final Property alarmClass = BObixAlarmDeviceExt.newProperty((int)6, (String)"defaultAlarmClass", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor"))));
    public static final Property watchInterval = BObixAlarmDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Property watchUri = BObixAlarmDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property debugWatch = BObixAlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action getClient = BObixAlarmDeviceExt.newAction((int)4, null);
    public static final Action submitAlarmDiscoveryJob = BObixAlarmDeviceExt.newAction((int)4, null);
    public static final Action subscribe = BObixAlarmDeviceExt.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BObixAlarmDeviceExt.class);
    private boolean attached = false;
    private ObixEncoder debugger = null;
    private Logger log = null;
    private Object mutexSubscribe = new Object();
    private Object mutexUnsubscribe = new Object();
    private TreeMap<String, BObixAlarmImport> pendingSubscribe = new TreeMap();
    private TreeMap<String, BObixAlarmImport> pendingUnsubscribe = new TreeMap();
    private boolean subscribing = false;
    private TreeMap<String, BObixAlarmImport> subscriptions = new TreeMap();
    private SessionWatch watch = null;

    public BRelTime getWatchInterval() {
        return (BRelTime)this.get(watchInterval);
    }

    public void setWatchInterval(BRelTime v) {
        this.set(watchInterval, (BValue)v, null);
    }

    public String getWatchUri() {
        return this.getString(watchUri);
    }

    public void setWatchUri(String v) {
        this.setString(watchUri, v, null);
    }

    public boolean getDebugWatch() {
        return this.getBoolean(debugWatch);
    }

    public void setDebugWatch(boolean v) {
        this.setBoolean(debugWatch, v, null);
    }

    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    public BOrd submitAlarmDiscoveryJob() {
        return (BOrd)this.invoke(submitAlarmDiscoveryJob, null, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach() {
        this.attached = true;
        BObixAlarmImport[] proxies = this.getProxies();
        Object object = this.mutexSubscribe;
        synchronized (object) {
            int i = proxies.length;
            while (--i >= 0) {
                this.pendingSubscribe.put(proxies[i].getHref(), proxies[i]);
            }
        }
        this.subscribe();
    }

    public void changed(Obj obj) {
        this.setLastReceivedTime(Clock.time());
        this.debug(obj);
        BObixAlarmImport proxy = this.subscriptions.get(obj.getHref().get());
        if (proxy == null) {
            this.getLogger().warning("No recipient for " + obj.toDisplayString());
        } else {
            proxy.processFeed(obj);
        }
        this.getObixClient().pingOk();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(watchInterval)) {
            try {
                if (this.watch != null) {
                    long millis = this.getWatchInterval().getMillis();
                    long lease = this.watch.getLease();
                    long safeLease = Math.max(millis * 2L, lease + this.getObixClient().getWatchSafetyFactor().getMillis());
                    this.watch.setLease(safeLease);
                    this.watch.setPollPeriod(millis);
                }
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("obix", "Invalid watch interval:" + this.getWatchInterval(), (Throwable)e);
            }
        }
    }

    public void closed(SessionWatch toClose) {
        if (toClose == this.watch) {
            this.watch = null;
            this.setWatchUri("");
            this.getLogger().fine("Watch closed " + toClose.getWatchObj().getHref().get());
            BObixClient client = this.getObixClient();
            if (client.getState().isEngaged()) {
                client.pingFail("Alarm watch unexpectedly closed.");
            }
        } else {
            this.getLogger().warning("Unknown watch closed " + toClose.getWatchObj().getHref().get());
        }
    }

    public void detach() {
        for (BObixAlarmImport p : this.subscriptions.values()) {
            p.unsubscribe();
        }
        this.subscriptions.clear();
        if (this.watch != null) {
            this.watch.delete();
            this.watch = null;
            this.setWatchUri("");
        }
        this.attached = false;
    }

    public BBoolean doAckAlarm(BAlarmRecord alarm) throws Exception {
        BString feedName = (BString)alarm.getAlarmFacet("feedName");
        if (feedName != null) {
            BObixAlarmImport feed = (BObixAlarmImport)this.get(feedName.getString());
            if (feed != null) {
                return feed.doAckAlarm(alarm);
            }
            return BBoolean.FALSE;
        }
        throw new BajaRuntimeException("Cannot find feedName to acknowledge alarm!");
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    public void doRouteAlarm(BAlarmRecord alarm) throws Exception {
        throw new RuntimeException("Not supported.");
    }

    public BOrd doSubmitAlarmDiscoveryJob(Context cx) {
        return new BObixAlarmDiscoveryJob(this, this.getObixClient().get("lobby")).submit(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSubscribe() {
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (this.subscribing) {
                return;
            }
            if (!this.isRunning()) {
                return;
            }
            if (!this.attached) {
                return;
            }
            this.subscribing = true;
        }
        try {
            this.performUnsubscribe();
            this.performSubscribe();
        }
        finally {
            this.subscribing = false;
            if (this.pendingSubscribe.size() > 0) {
                this.subscribe();
            } else if (this.pendingUnsubscribe.size() > 0) {
                this.subscribe();
            }
        }
    }

    public Type getAlarmImportType() {
        return BObixAlarmImport.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public Logger getLogger() {
        if (this.log == null) {
            try {
                this.log = Logger.getLogger(this.getObixClient().getLogger().getName() + "-Alarms");
            }
            catch (Exception x) {
                this.log = this.getObixClient().getLogger();
            }
        }
        return this.log;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean isChildLegal(BComponent comp) {
        return true;
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"ObixAlarmDeviceExt", 2);
        out.prop((Object)"attached", this.attached);
        out.prop((Object)"debugger", (Object)this.debugger);
        out.prop((Object)"log", (Object)this.getLogger().getName());
        out.prop((Object)"pendingSubscribe", this.pendingSubscribe);
        out.prop((Object)"pendingUnsubscribe", this.pendingUnsubscribe);
        out.prop((Object)"subscribing", this.subscribing);
        out.prop((Object)"subscriptions", this.subscriptions);
        out.prop((Object)"watch", (Object)this.watch);
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String href, BObixAlarmImport ext, Context cx) {
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.put(href, ext);
        }
        this.subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String href, BObixAlarmImport ext, Context cx) {
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(href, ext);
        }
        this.subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSubscribe() {
        TreeMap<String, BObixAlarmImport> tmp = null;
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (this.pendingSubscribe.size() > 0) {
                tmp = this.pendingSubscribe;
                this.pendingSubscribe = new TreeMap();
            }
        }
        if (tmp != null) {
            object = this.mutexSubscribe;
            synchronized (object) {
                if (this.watch == null) {
                    try {
                        long millis = this.getWatchInterval().getMillis();
                        this.watch = this.getObixClient().makeWatch(this.getName(), millis, this);
                        long lease = this.watch.getLease();
                        long safeLease = Math.max(millis * 2L, lease + this.getObixClient().getWatchSafetyFactor().getMillis());
                        this.watch.setLease(safeLease);
                        this.watch.setPollPeriod(millis);
                        this.setWatchUri(this.watch.getWatchObj().getHref().get());
                        this.getLogger().fine("Watch created " + this.watch.getWatchObj().getHref().get());
                    }
                    catch (Exception x) {
                        this.getLogger().log(Level.SEVERE, "Watch creation failed", x);
                    }
                }
            }
            BObixAlarmImport proxy = null;
            Iterator<BObixAlarmImport> i = tmp.values().iterator();
            if (this.watch == null) {
                while (i.hasNext()) {
                    proxy = i.next();
                    proxy.subscribeFail("Watch creation failed");
                }
            }
            block13: while (true) {
                try {
                    while (i.hasNext()) {
                        proxy = i.next();
                        BObixAlarmImport oai = this.subscriptions.get(proxy.getHref());
                        if (oai != null && oai != proxy) {
                            proxy.subscribeFail("Href already subscribed by " + oai.toPathString());
                            continue;
                        }
                        try {
                            Obj res = this.watch.add(new Uri(proxy.getHref()));
                            if (res.isErr()) {
                                proxy.subscribeFail(res.toDisplayString());
                                this.subscriptions.remove(proxy.getHref());
                                continue block13;
                            }
                            this.subscriptions.put(proxy.getHref(), proxy);
                            proxy.subscribeOk(res);
                            continue block13;
                        }
                        catch (Exception x) {
                            this.subscriptions.remove(proxy.getHref());
                            this.getLogger().log(Level.SEVERE, "Subscribing " + proxy.getHref(), x);
                            proxy.subscribeFail(x.toString());
                        }
                    }
                    break;
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, "Subscribing " + proxy.getHref(), x);
                    this.subscriptions.remove(proxy.getHref());
                    proxy.subscribeFail(x.toString());
                    break;
                }
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performUnsubscribe() {
        TreeMap<String, BObixAlarmImport> tmp = null;
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            if (this.pendingUnsubscribe.size() > 0) {
                tmp = this.pendingUnsubscribe;
                this.pendingUnsubscribe = new TreeMap();
            }
        }
        if (tmp != null) {
            Vector<Uri> v = new Vector<Uri>(tmp.size());
            for (String href : tmp.keySet()) {
                BObixAlarmImport proxy = tmp.get(href);
                if (this.subscriptions.get(href) == proxy) {
                    v.addElement(new Uri(href));
                }
                proxy.unsubscribe();
            }
            if (v.size() == 0) {
                return;
            }
            Object[] toRemove = new Uri[v.size()];
            v.copyInto(toRemove);
            if (this.watch != null) {
                try {
                    this.watch.remove((Uri[])toRemove);
                }
                catch (Exception proxy) {
                    // empty catch block
                }
            }
            int j = toRemove.length;
            while (--j >= 0) {
                this.subscriptions.remove(toRemove[j].get());
            }
            tmp = null;
        }
    }

    private void debug(Obj obj) {
        if (!this.getDebugWatch()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = ObixEncoder.make((OutputStream)System.out, null);
            }
            System.out.println(this.toPathString() + " Alarms:");
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BObixAlarmImport[] getProxies() {
        ArrayList<BObixAlarmImport> list = new ArrayList<BObixAlarmImport>();
        this.getProxies((BComponent)this, list);
        return list.toArray(new BObixAlarmImport[list.size()]);
    }

    private void getProxies(BComponent comp, ArrayList<BObixAlarmImport> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid instanceof BObixAlarmImport) {
                list.add((BObixAlarmImport)kid);
                continue;
            }
            this.getProxies(kid, list);
        }
    }
}

