/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;

public final class WebLauncherUtil {
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static URLClassLoader nreClassLoader;
    private static final String JETTY_VERSION;

    private WebLauncherUtil() {
    }

    public static boolean checkCert(X509Certificate[] certs, URI uri, String mainFrameUrl, boolean showDialog) throws Exception {
        return AccessController.doPrivileged(() -> {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader nreClassLoader = WebLauncherUtil.getNreClassLoader();
            Thread.currentThread().setContextClassLoader(nreClassLoader);
            try {
                Class<?> httpsInitClass = nreClassLoader.loadClass("com.tridium.wblite.VerifyCertificateCallbackUtil");
                Method initializeMethod = httpsInitClass.getMethod("checkApproval", certs.getClass(), URI.class, String.class, Boolean.TYPE);
                Boolean bl = (boolean)((Boolean)initializeMethod.invoke(null, certs, uri, mainFrameUrl, showDialog));
                return bl;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        });
    }

    private static URLClassLoader getNreClassLoader() throws Exception {
        if (nreClassLoader != null) {
            return nreClassLoader;
        }
        String root = System.getProperty("user.dir");
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL("file:" + root + "/ext/nre.jar"));
        urls.add(new URL("file:" + root + "/ext/wblite.jar"));
        urls.add(new URL("file:" + root + "/ext/jetty-all-compact3-" + JETTY_VERSION + ".jar"));
        File bcDirectory = new File(root + "/ext/bcstd");
        for (File file : Objects.requireNonNull(bcDirectory.listFiles())) {
            String fileName = file.getName();
            if (!file.isFile() || !fileName.startsWith("bc") || !fileName.endsWith(".jar")) continue;
            urls.add(new URL("file:" + root + "/ext/bcstd/" + fileName));
        }
        nreClassLoader = new URLClassLoader(urls.toArray(EMPTY_URL_ARRAY), null);
        return nreClassLoader;
    }

    static {
        JETTY_VERSION = AccessController.doPrivileged(() -> System.getProperty("niagara.jetty.version"));
    }
}

