/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.teamdev.jxbrowser.js.JsObject;
import com.tridium.workbench.web.browser.IJs;
import java.security.AccessController;
import javax.baja.nre.util.Array;

public final class JxJs
implements IJs {
    private Object obj;

    private JxJs(Object obj) {
        this.obj = obj;
    }

    static IJs make(Object o) {
        if (o == null) {
            return new JxJs(o);
        }
        if (o instanceof IJs) {
            return (IJs)o;
        }
        if (o instanceof Boolean || o instanceof Number || o instanceof String || o instanceof JsObject) {
            return new JxJs(o);
        }
        throw new IllegalArgumentException("Cannot create argument from: " + o);
    }

    public IJs[] toArray() {
        if (!this.isObject()) {
            return emptyArray;
        }
        Array a = null;
        int length = this.get("length").toInt();
        for (int i = 0; i < length; ++i) {
            if (a == null) {
                a = new Array(IJs.class);
            }
            a.add((Object)this.get(i));
        }
        return a == null ? emptyArray : (IJs[])a.trim();
    }

    public IJs get(String nm) {
        return AccessController.doPrivileged(() -> JxJs.make(this.asJsObject().property(nm).orElse(null)));
    }

    public IJs get(int i) {
        return this.get(String.valueOf(i));
    }

    public IJs call(String nm, Object ... args) {
        return JxJs.make(this.asJsObject().call(nm, args));
    }

    public boolean isNumber() {
        return !this.isNull() && this.obj instanceof Number;
    }

    public int toInt() {
        if (this.isNull()) {
            return 0;
        }
        if (this.obj instanceof Number) {
            ((Number)this.obj).intValue();
        }
        return Integer.parseInt(this.obj.toString());
    }

    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        if (this.obj instanceof Number) {
            ((Number)this.obj).doubleValue();
        }
        return Double.parseDouble(this.obj.toString());
    }

    public boolean isBoolean() {
        return !this.isNull() && this.obj instanceof Boolean;
    }

    public boolean toBool() {
        if (this.isNull()) {
            return false;
        }
        if (this.obj instanceof Boolean) {
            return (Boolean)this.obj;
        }
        return Boolean.parseBoolean(this.obj.toString());
    }

    public boolean isNull() {
        return this.obj == null;
    }

    public void set(String name, boolean booleanValue) {
        AccessController.doPrivileged(() -> {
            this.asJsObject().putProperty(name, (Object)booleanValue);
            return null;
        });
    }

    public void set(String name, String stringValue) {
        AccessController.doPrivileged(() -> {
            this.asJsObject().putProperty(name, (Object)stringValue);
            return null;
        });
    }

    public void set(String name, int intValue) {
        AccessController.doPrivileged(() -> {
            this.asJsObject().putProperty(name, (Object)intValue);
            return null;
        });
    }

    public void set(String name, double doubleValue) {
        AccessController.doPrivileged(() -> {
            this.asJsObject().putProperty(name, (Object)doubleValue);
            return null;
        });
    }

    public void setMember(String name, Object value) {
        this.asJsObject().putProperty(name, value);
    }

    public boolean isObject() {
        return this.obj instanceof JsObject;
    }

    public String toString() {
        String s = null;
        if (this.isObject()) {
            s = AccessController.doPrivileged(() -> this.asJsObject().hasProperty("toString") ? (String)this.asJsObject().call("toString", new Object[0]) : null);
        }
        return s == null ? String.valueOf(this.obj) : s;
    }

    private JsObject asJsObject() {
        return (JsObject)this.obj;
    }
}

