/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.tridium.web.SnoopHtmlWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JxBrowserSnoopWriter
extends SnoopHtmlWriter {
    private static final Logger log = Logger.getLogger("jxbrowser.snoop");

    public JxBrowserSnoopWriter(Writer out) {
        super(out);
    }

    protected void setIgnoreNoSnoop(boolean ignoreNoSnoop) {
        this.ignoreNoSnoop = ignoreNoSnoop;
    }

    public static void pipe(InputStream in, Writer out) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(in));
        JxBrowserSnoopWriter snoop = new JxBrowserSnoopWriter(out);
        snoop.setIgnoreNoSnoop(true);
        snoop.pipe(reader);
    }

    protected String hrefToUri(String href, Optional<String> tag) {
        if (href.startsWith("file:")) {
            try {
                return "https://workbench/file.html?" + URLEncoder.encode(href, "UTF-8");
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot encode href for snooping" + href);
                return href;
            }
        }
        return href;
    }
}

