/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BDefaultBattery;
import com.tridium.platPower.BIPowerService;
import com.tridium.platPower.BNpm2NimhBattery;
import com.tridium.platPower.BPowerState;
import com.tridium.platPower.PowerdQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.qnx.BSystemPlatformServiceQnxLegacy;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public abstract class BPowerMonitorPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
BIPowerService {
    public static final Property primaryPowerPresent = BPowerMonitorPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property shutdownDelay = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)}));
    public static final Property powerAlarmSupport = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BPowerMonitorPlatformService.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BPowerMonitorPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property battery = BPowerMonitorPlatformService.newProperty((int)3, (BValue)new BDefaultBattery(), null);
    public static final Property batteryGood = BPowerMonitorPlatformService.newProperty((int)1, (boolean)false, null);
    public static final Property timeOfLastTest = BPowerMonitorPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property batteryAlarmSupport = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BPowerMonitorPlatformService.initBatteryAlarmSupport(), null);
    public static final Property batteryAlarmProxy = BPowerMonitorPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action pollTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action dischargeTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Topic powerState = BPowerMonitorPlatformService.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BPowerMonitorPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"batteryFull.png");
    public static Logger log = Logger.getLogger("power");
    private Clock.Ticket primaryTicket;
    private Clock.Ticket pollTicket;
    private Clock.Ticket shutdownTicket;
    private Clock.Ticket dischargeTicket;
    int lastChargeLevel = -1;
    private boolean firstPass = true;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_BATTERY = "battery";

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean v) {
        this.setBoolean(primaryPowerPresent, v, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime v) {
        this.set(shutdownDelay, (BValue)v, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport v) {
        this.set(powerAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy v) {
        this.set(powerAlarmProxy, (BValue)v, null);
    }

    public BBattery getBattery() {
        return (BBattery)this.get(battery);
    }

    public void setBattery(BBattery v) {
        this.set(battery, (BValue)v, null);
    }

    public boolean getBatteryGood() {
        return this.getBoolean(batteryGood);
    }

    public void setBatteryGood(boolean v) {
        this.setBoolean(batteryGood, v, null);
    }

    public BAbsTime getTimeOfLastTest() {
        return (BAbsTime)this.get(timeOfLastTest);
    }

    public void setTimeOfLastTest(BAbsTime v) {
        this.set(timeOfLastTest, (BValue)v, null);
    }

    public BPlatformAlarmSupport getBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(batteryAlarmSupport);
    }

    public void setBatteryAlarmSupport(BPlatformAlarmSupport v) {
        this.set(batteryAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(batteryAlarmProxy);
    }

    public void setBatteryAlarmProxy(BPlatformAlarmProxy v) {
        this.set(batteryAlarmProxy, (BValue)v, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void pollTimerExpired() {
        this.invoke(pollTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public void dischargeTimerExpired() {
        this.invoke(dischargeTimerExpired, null, null);
    }

    public void firePowerState(BPowerState event) {
        this.fire(powerState, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPowerMonitorPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    public abstract BBattery getBatteryInstance();

    public abstract boolean isPrimaryPresent();

    public void doStationStarted(BStation station) {
        BRelTime configuredDelay;
        BRelTime validatedDelay;
        super.doStationStarted(station);
        try {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (sysService instanceof BSystemPlatformServiceQnxLegacy) {
                BSystemPlatformServiceQnxLegacy sysServiceQnx = (BSystemPlatformServiceQnxLegacy)sysService;
                sysServiceQnx.checkPropertiesLoaded();
                if (!sysServiceQnx.getIsBatteryPresent()) {
                    return;
                }
            }
        }
        catch (ServiceNotFoundException sysService) {
            // empty catch block
        }
        this.loadLibraries();
        BBattery b = this.getBatteryInstance();
        this.setBattery(b);
        this.getBatteryAlarmProxy().setAlarmSupport(this.getBatteryAlarmSupport());
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        boolean tenMinuteDefault = false;
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                tenMinuteDefault = true;
            }
        }
        catch (Exception dataRecoveryService) {
            // empty catch block
        }
        if (!tenMinuteDefault && this.getBatteryInstance() instanceof BNpm2NimhBattery && this.getShutdownDelay().getMillis() > BRelTime.makeMinutes((int)1).getMillis()) {
            this.setShutdownDelay(BRelTime.makeMinutes((int)1));
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        if (!(validatedDelay = b.validateShutdownDelay(configuredDelay = this.getShutdownDelay())).equals((Object)configuredDelay)) {
            log.warning("Invalid shutdown delay detected, setting to default");
            this.setShutdownDelay(validatedDelay);
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        this.doPrimaryTimerExpired();
        this.doPollTimerExpired();
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollTimerExpired, null);
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.primaryTicket != null) {
            this.primaryTicket.cancel();
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    public void changed(Property prop, Context cx) {
        BRelTime configuredDelay;
        BBattery b;
        BRelTime validatedDelay;
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop == shutdownDelay && !(validatedDelay = (b = this.getBattery()).validateShutdownDelay(configuredDelay = this.getShutdownDelay())).equals((Object)configuredDelay)) {
            log.warning("Invalid shutdown delay detected, setting to default");
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
            this.setShutdownDelay(validatedDelay);
        }
    }

    public void doPrimaryTimerExpired() {
        boolean primaryPresent = this.isPrimaryPresent();
        boolean lastPrimaryPresent = this.getPrimaryPowerPresent();
        this.setPrimaryPowerPresent(primaryPresent);
        if (!primaryPresent) {
            if (lastPrimaryPresent || this.firstPass) {
                log.info("Primary power lost");
                this.firePowerState(BPowerState.lost);
                if (!this.getBattery().isBatteryGood()) {
                    log.info("Battery bad, shutting down immediately");
                    this.doShutdownTimerExpired();
                    return;
                }
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                try {
                    if (this.getBatteryInstance() instanceof BNpm2NimhBattery) {
                        this.lastChargeLevel = PowerdQnx.getBatteryCharge();
                        this.dischargeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)dischargeTimerExpired, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BPlatformServiceAlarmRecord alarm = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            }
        } else if (primaryPresent && !lastPrimaryPresent) {
            log.info("Primary power restored");
            this.firePowerState(BPowerState.restored);
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            if (this.dischargeTicket != null) {
                this.dischargeTicket.cancel();
            }
            BPlatformServiceAlarmRecord alarm = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(alarm);
        }
        this.firstPass = false;
    }

    public void doPollTimerExpired() {
        if (!this.getPrimaryPowerPresent()) {
            return;
        }
        BBattery b = this.getBattery();
        boolean batteryOk = b.isBatteryGood();
        boolean lastBatteryOk = this.getBatteryGood();
        this.setTimeOfLastTest(b.getTestTime());
        this.setBatteryGood(batteryOk);
        if (batteryOk != lastBatteryOk) {
            if (!batteryOk && lastBatteryOk) {
                log.info("Battery test failed");
                BPlatformServiceAlarmRecord alarm = this.getBatteryAlarmSupport().makeNewFaultAlarm();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            } else if (batteryOk && !lastBatteryOk) {
                log.info("Battery test passed");
                BPlatformServiceAlarmRecord alarm = this.getBatteryAlarmSupport().makeToNormal();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            }
        }
        b.refresh();
    }

    public void doDischargeTimerExpired() {
        if (this.getBatteryInstance() instanceof BNpm2NimhBattery) {
            try {
                int charge = PowerdQnx.getBatteryCharge();
                if (charge == 0) {
                    log.info("NiMH battery discharged, shutting down");
                    this.doShutdownTimerExpired();
                } else if (charge != this.lastChargeLevel) {
                    log.info("NiMH charge was ~" + this.lastChargeLevel + " %, now ~" + charge + "%");
                    this.lastChargeLevel = charge;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doShutdownTimerExpired() {
        log.info("Primary power loss shutdown timer expired, saving database, shutting down");
        if (this.dischargeTicket != null) {
            this.dischargeTicket.cancel();
        }
        try {
            BSystemPlatformService sp = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sp.reboot();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(listener);
        this.getBatteryAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(listener);
        this.getBatteryAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initBatteryAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setToFaultText(BFormat.make((String)"%lexicon(platPower:batteryTestFail)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platPower:batteryTestPassed)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_BATTERY));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    protected abstract void loadLibraries();

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }
}

