/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BIPowerService;
import com.tridium.platPower.BNpm2NimhBattery;
import com.tridium.platPower.BNpmExternalSlaBattery;
import com.tridium.platPower.PowerdQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.qnx.BSystemPlatformServiceQnxLegacy;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BNpmDualBatteryPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
BIPowerService {
    public static final Property primaryPowerPresent = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property shutdownDelay = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)}));
    public static final Property powerAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property nimhBattery = BNpmDualBatteryPlatformService.newProperty((int)3, (BValue)new BNpm2NimhBattery(), null);
    public static final Property nimhBatteryGood = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property nimhBatteryTimeOfLastTest = BNpmDualBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property nimhBatteryAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initNimhBatteryAlarmSupport(), null);
    public static final Property nimhBatteryAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property slaBatteryPresent = BNpmDualBatteryPlatformService.newProperty((int)0, (boolean)false, null);
    public static final Property slaBattery = BNpmDualBatteryPlatformService.newProperty((int)3, (BValue)new BNpmExternalSlaBattery(), null);
    public static final Property slaBatteryGood = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property slaBatteryTimeOfLastTest = BNpmDualBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property slaBatteryAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initSlaBatteryAlarmSupport(), null);
    public static final Property slaBatteryAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action pollTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action dischargeTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNpmDualBatteryPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"batteryFull.png");
    public static Logger log = Logger.getLogger("power");
    private Clock.Ticket primaryTicket;
    private Clock.Ticket pollTicket;
    private Clock.Ticket shutdownTicket;
    private Clock.Ticket dischargeTicket;
    int lastChargeLevel = -1;
    boolean firstPass = true;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_NIMH_BATTERY = "nimhBattery";
    private static final String ALARM_TYPE_SLA_BATTERY = "slaBattery";

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean v) {
        this.setBoolean(primaryPowerPresent, v, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime v) {
        this.set(shutdownDelay, (BValue)v, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport v) {
        this.set(powerAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy v) {
        this.set(powerAlarmProxy, (BValue)v, null);
    }

    public BBattery getNimhBattery() {
        return (BBattery)this.get(nimhBattery);
    }

    public void setNimhBattery(BBattery v) {
        this.set(nimhBattery, (BValue)v, null);
    }

    public boolean getNimhBatteryGood() {
        return this.getBoolean(nimhBatteryGood);
    }

    public void setNimhBatteryGood(boolean v) {
        this.setBoolean(nimhBatteryGood, v, null);
    }

    public BAbsTime getNimhBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(nimhBatteryTimeOfLastTest);
    }

    public void setNimhBatteryTimeOfLastTest(BAbsTime v) {
        this.set(nimhBatteryTimeOfLastTest, (BValue)v, null);
    }

    public BPlatformAlarmSupport getNimhBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(nimhBatteryAlarmSupport);
    }

    public void setNimhBatteryAlarmSupport(BPlatformAlarmSupport v) {
        this.set(nimhBatteryAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getNimhBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(nimhBatteryAlarmProxy);
    }

    public void setNimhBatteryAlarmProxy(BPlatformAlarmProxy v) {
        this.set(nimhBatteryAlarmProxy, (BValue)v, null);
    }

    public boolean getSlaBatteryPresent() {
        return this.getBoolean(slaBatteryPresent);
    }

    public void setSlaBatteryPresent(boolean v) {
        this.setBoolean(slaBatteryPresent, v, null);
    }

    public BBattery getSlaBattery() {
        return (BBattery)this.get(slaBattery);
    }

    public void setSlaBattery(BBattery v) {
        this.set(slaBattery, (BValue)v, null);
    }

    public boolean getSlaBatteryGood() {
        return this.getBoolean(slaBatteryGood);
    }

    public void setSlaBatteryGood(boolean v) {
        this.setBoolean(slaBatteryGood, v, null);
    }

    public BAbsTime getSlaBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(slaBatteryTimeOfLastTest);
    }

    public void setSlaBatteryTimeOfLastTest(BAbsTime v) {
        this.set(slaBatteryTimeOfLastTest, (BValue)v, null);
    }

    public BPlatformAlarmSupport getSlaBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(slaBatteryAlarmSupport);
    }

    public void setSlaBatteryAlarmSupport(BPlatformAlarmSupport v) {
        this.set(slaBatteryAlarmSupport, (BValue)v, null);
    }

    public BPlatformAlarmProxy getSlaBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(slaBatteryAlarmProxy);
    }

    public void setSlaBatteryAlarmProxy(BPlatformAlarmProxy v) {
        this.set(slaBatteryAlarmProxy, (BValue)v, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void pollTimerExpired() {
        this.invoke(pollTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public void dischargeTimerExpired() {
        this.invoke(dischargeTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNpmDualBatteryPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    public boolean isValidPlatform() {
        return false;
    }

    protected void loadLibraries() {
        log.fine("Loading libPower.so...");
        PowerdQnx.loadLibraries();
        PowerdQnx.open();
    }

    public boolean isPrimaryPresent() {
        return PowerdQnx.isPrimaryPresent();
    }

    public void doStationStarted(BStation station) {
        super.doStationStarted(station);
        try {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (sysService instanceof BSystemPlatformServiceQnxLegacy) {
                BSystemPlatformServiceQnxLegacy sysServiceQnx = (BSystemPlatformServiceQnxLegacy)sysService;
                sysServiceQnx.checkPropertiesLoaded();
                if (!sysServiceQnx.getIsBatteryPresent()) {
                    return;
                }
            }
        }
        catch (ServiceNotFoundException sysService) {
            // empty catch block
        }
        this.loadLibraries();
        this.getNimhBatteryAlarmProxy().setAlarmSupport(this.getNimhBatteryAlarmSupport());
        this.getSlaBatteryAlarmProxy().setAlarmSupport(this.getSlaBatteryAlarmSupport());
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        boolean tenMinuteDefault = false;
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                tenMinuteDefault = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!tenMinuteDefault && !this.getSlaBatteryPresent() && this.getShutdownDelay().getMillis() > BRelTime.makeMinutes((int)1).getMillis()) {
            this.setShutdownDelay(BRelTime.makeMinutes((int)1));
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        this.doPrimaryTimerExpired();
        this.doPollTimerExpired();
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollTimerExpired, null);
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.primaryTicket != null) {
            this.primaryTicket.cancel();
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    public void doPrimaryTimerExpired() {
        boolean primaryPresent = this.isPrimaryPresent();
        boolean lastPrimaryPresent = this.getPrimaryPowerPresent();
        this.setPrimaryPowerPresent(primaryPresent);
        if (!primaryPresent) {
            if (lastPrimaryPresent || this.firstPass) {
                log.info("Primary power lost");
                if (this.getSlaBatteryPresent()) {
                    if (!this.getNimhBattery().isBatteryGood() || !this.getSlaBattery().isBatteryGood()) {
                        log.info("Batteries bad, shutting down immediately");
                        this.doShutdownTimerExpired();
                        return;
                    }
                } else if (!this.getNimhBattery().isBatteryGood()) {
                    log.info("Battery bad, shutting down immediately");
                    this.doShutdownTimerExpired();
                    return;
                }
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                this.lastChargeLevel = PowerdQnx.getBatteryCharge();
                this.dischargeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)dischargeTimerExpired, null);
                BPlatformServiceAlarmRecord alarm = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(alarm);
            }
        } else if (primaryPresent && !lastPrimaryPresent) {
            log.info("Primary power restored");
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            if (this.dischargeTicket != null) {
                this.dischargeTicket.cancel();
            }
            BPlatformServiceAlarmRecord alarm = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(alarm);
        }
        this.firstPass = false;
    }

    public boolean checkBattery(BBattery b, String name, boolean lastBatteryOk, BPlatformAlarmSupport alarmSupport, BPlatformAlarmProxy alarmProxy) {
        boolean batteryOk = b.isBatteryGood();
        if (batteryOk != lastBatteryOk) {
            if (!batteryOk && lastBatteryOk) {
                log.info(name + " battery test failed");
                BPlatformServiceAlarmRecord alarm = alarmSupport.makeNewFaultAlarm();
                alarmProxy.firePlatformServiceAlarmEvent(alarm);
            } else if (batteryOk && !lastBatteryOk) {
                log.info(name + " battery test passed");
                BPlatformServiceAlarmRecord alarm = alarmSupport.makeToNormal();
                alarmProxy.firePlatformServiceAlarmEvent(alarm);
            }
        }
        return batteryOk;
    }

    public void doPollTimerExpired() {
        if (!this.isPrimaryPresent()) {
            return;
        }
        BBattery nimh = this.getNimhBattery();
        boolean nimhOk = this.checkBattery(this.getNimhBattery(), "NiMH", this.getNimhBatteryGood(), this.getNimhBatteryAlarmSupport(), this.getNimhBatteryAlarmProxy());
        this.setNimhBatteryTimeOfLastTest(nimh.getTestTime());
        this.setNimhBatteryGood(nimhOk);
        nimh.refresh();
        if (this.getSlaBatteryPresent()) {
            BBattery sla = this.getSlaBattery();
            boolean slaOk = this.checkBattery(this.getSlaBattery(), "SLA", this.getSlaBatteryGood(), this.getSlaBatteryAlarmSupport(), this.getSlaBatteryAlarmProxy());
            this.setSlaBatteryTimeOfLastTest(sla.getTestTime());
            this.setSlaBatteryGood(slaOk);
            sla.refresh();
        }
    }

    public void doDischargeTimerExpired() {
        int charge = PowerdQnx.getBatteryCharge();
        if (charge == 0) {
            log.info("NiMH battery discharged, shutting down");
            this.doShutdownTimerExpired();
        } else if (charge != this.lastChargeLevel) {
            log.info("NiMH charge was ~" + this.lastChargeLevel + " %, now ~" + charge + "%");
            this.lastChargeLevel = charge;
        }
    }

    public void doShutdownTimerExpired() {
        log.info("Primary power loss shutdown timer expired, saving database, shutting down");
        if (this.dischargeTicket != null) {
            this.dischargeTicket.cancel();
        }
        try {
            BSystemPlatformService sp = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sp.reboot();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(listener);
        this.getNimhBatteryAlarmProxy().addPlatformServiceAlarmListener(listener);
        this.getSlaBatteryAlarmProxy().addPlatformServiceAlarmListener(listener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener listener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(listener);
        this.getNimhBatteryAlarmProxy().removePlatformServiceAlarmListener(listener);
        this.getSlaBatteryAlarmProxy().removePlatformServiceAlarmListener(listener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord alarmData) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initNimhBatteryAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setToFaultText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestFail)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestPassed)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_NIMH_BATTERY));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    static BPlatformAlarmSupport initSlaBatteryAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setToFaultText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestFail)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestPassed)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_SLA_BATTERY));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport pas = new BPlatformAlarmSupport();
        pas.setSourceName(BFormat.make((String)"%parent.displayName%"));
        pas.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        pas.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        pas.setMetaData(BFacets.make(map));
        return pas;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }
}

