/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BBatteryState;
import com.tridium.platPower.PowerdQnx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNimhBattery
extends BBattery {
    public static final Property state = BNimhBattery.newProperty((int)3, (BValue)BBatteryState.unknown, null);
    public static final Property chargeTimeLeft = BNimhBattery.newProperty((int)3, (BValue)BRelTime.makeMinutes((int)0), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BNimhBattery.class);
    private static final BFacets shutdownDelayFacetsDRS = BFacets.make((String[])new String[]{"showSeconds", "min", "max"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0), BRelTime.makeMinutes((int)10)});
    private static final BFacets shutdownDelayFacets = BFacets.make((String[])new String[]{"showSeconds", "min", "max"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0), BRelTime.makeMinutes((int)1)});
    public static Logger log = Logger.getLogger("power");

    public BBatteryState getState() {
        return (BBatteryState)this.get(state);
    }

    public void setState(BBatteryState v) {
        this.set(state, (BValue)v, null);
    }

    public BRelTime getChargeTimeLeft() {
        return (BRelTime)this.get(chargeTimeLeft);
    }

    public void setChargeTimeLeft(BRelTime v) {
        this.set(chargeTimeLeft, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isBatteryPresent()) {
            return;
        }
        PowerdQnx.open();
    }

    @Override
    public boolean isBatteryGood() {
        try {
            return PowerdQnx.isBatteryGood();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error checking NiMH battery", e);
            return false;
        }
    }

    @Override
    public BAbsTime getTestTime() {
        try {
            return BAbsTime.make((long)PowerdQnx.getBatteryTestTime());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error checking NiMH battery test time", e);
            return BAbsTime.NULL;
        }
    }

    @Override
    public BRelTime validateShutdownDelay(BRelTime delay) {
        BRelTime maxDelay = BRelTime.makeMinutes((int)1);
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                maxDelay = BRelTime.makeMinutes((int)10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (delay.getMillis() > maxDelay.getMillis()) {
            return maxDelay;
        }
        return delay;
    }

    @Override
    public void refresh() {
        this.setState(PowerdQnx.getBatteryState());
        this.setChargeTimeLeft(PowerdQnx.getBatteryChargeTime());
    }

    @Override
    public BFacets doGetShutdownDelayFacets() {
        try {
            Property prop;
            BComponent serviceAsComponent;
            BFrozenEnum status;
            BIDataRecoveryService dataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (dataRecoveryService.isEnabled() && (status = (BFrozenEnum)(serviceAsComponent = (BComponent)dataRecoveryService).get(prop = serviceAsComponent.getProperty("dataRecoveryStatus"))) != null && status.getOrdinal() != 8) {
                return shutdownDelayFacetsDRS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return shutdownDelayFacets;
    }
}

