/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.PowerdQnx;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BJaceSlaBattery
extends BBattery {
    public static final Action batteryTestTimerExpired = BJaceSlaBattery.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BJaceSlaBattery.class);
    private static final BFacets shutdownDelayFacets = BFacets.make((String[])new String[]{"showSeconds", "min", "max"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0), BRelTime.makeMinutes((int)15)});
    private Clock.Ticket batteryTicket;
    boolean batteryGood = true;
    BAbsTime timeOfLastTest = BAbsTime.NULL;
    public static Logger log = Logger.getLogger("power");

    public void batteryTestTimerExpired() {
        this.invoke(batteryTestTimerExpired, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isBatteryPresent()) {
            return;
        }
        this.loadLibraries();
        PowerdQnx.open();
        this.doBatteryTestTimerExpired();
        this.batteryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)15), (Action)batteryTestTimerExpired, null);
    }

    public void stopped() throws Exception {
        if (this.batteryTicket != null) {
            this.batteryTicket.cancel();
        }
    }

    public void doBatteryTestTimerExpired() {
        if (!PowerdQnx.isPrimaryPresent()) {
            log.fine("Primary power lost, skipping battery test");
            return;
        }
        this.batteryGood = PowerdQnx.testBattery();
        this.timeOfLastTest = Clock.time();
        if (this.batteryGood) {
            log.fine("battery test passed");
        } else {
            log.fine("battery test failed");
        }
    }

    @Override
    public boolean isBatteryGood() {
        return this.batteryGood;
    }

    @Override
    public BAbsTime getTestTime() {
        return this.timeOfLastTest;
    }

    @Override
    public BRelTime validateShutdownDelay(BRelTime delay) {
        if (delay.getMillis() > 900000L) {
            return BRelTime.make((long)900000L);
        }
        return delay;
    }

    @Override
    public void refresh() {
    }

    @Override
    public BFacets doGetShutdownDelayFacets() {
        return shutdownDelayFacets;
    }
}

