/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.util;

public class LinkedQueue {
    ILinkable head;
    ILinkable tail;
    int size;

    public synchronized ILinkable dequeue() {
        try {
            if (this.size == 0) {
                this.wait();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getNext();
    }

    public synchronized ILinkable dequeue(int timeout) {
        try {
            if (this.size == 0 && timeout > 0) {
                this.wait(timeout);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getNext();
    }

    private ILinkable getNext() {
        ILinkable lnkable = this.head;
        if (lnkable == null) {
            return null;
        }
        this.head = lnkable.getNext();
        if (this.head == null) {
            this.tail = null;
        }
        lnkable.setNext(null);
        --this.size;
        return lnkable;
    }

    public synchronized void enqueue(ILinkable value) {
        value.setNext(null);
        if (this.tail == null) {
            this.head = this.tail = value;
        } else {
            this.tail.setNext(value);
            this.tail = value;
        }
        ++this.size;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public static interface ILinkable {
        public ILinkable getNext();

        public void setNext(ILinkable var1);
    }
}

