/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.util;

import com.tridium.ndriver.util.LinkedQueue;

public class LinkedPool {
    private PoolLinkable[] pool;
    private int poolCnt = 0;
    private Class<?> cls;

    public LinkedPool(int maxPool, Class<?> cls) {
        this.pool = new PoolLinkable[maxPool];
        this.cls = cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PoolLinkable get() throws Exception {
        PoolLinkable[] poolLinkableArray = this.pool;
        synchronized (this.pool) {
            PoolLinkable pl = this.poolCnt > 0 ? this.pool[--this.poolCnt] : this.create();
            pl.claim();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return pl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(PoolLinkable pl) {
        PoolLinkable[] poolLinkableArray = this.pool;
        synchronized (this.pool) {
            while (pl != null) {
                if (pl.isFree()) {
                    System.out.println("already free");
                    Thread.dumpStack();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                if (this.poolCnt < this.pool.length) {
                    this.pool[this.poolCnt++] = pl;
                }
                pl = (PoolLinkable)pl.getNext();
                pl.free();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public PoolLinkable create() throws Exception {
        return (PoolLinkable)this.cls.newInstance();
    }

    public static abstract class PoolLinkable
    implements LinkedQueue.ILinkable {
        private boolean free = true;
        private PoolLinkable next = null;

        public abstract void init();

        public abstract void release();

        void claim() {
            this.init();
            this.free = false;
        }

        void free() {
            this.release();
            this.free = true;
            this.next = null;
        }

        boolean isFree() {
            return this.free;
        }

        @Override
        public LinkedQueue.ILinkable getNext() {
            return this.next;
        }

        @Override
        public void setNext(LinkedQueue.ILinkable nxt) {
            this.next = (PoolLinkable)nxt;
        }
    }
}

