/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.util;

import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BPxView;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;

public class AgentInfoUtil
implements AgentInfo {
    protected AgentInfo nAgentInfo;
    protected String driverModuleName;
    protected String displayNameKey;
    protected String displayNameDefault;
    private static final String N_DEVICE_MANAGER = "ndriver:NDeviceManager";
    private static final String DEVICE_MGR_SUFFIX_KEY = "DeviceManager";
    private static final String DEVICE_MGR_SUFFIX_DEFAULT = "Device Manager";
    private static final String N_DEVICE_UX_MANAGER = "ndriver:NDeviceUxManager";
    private static final String DEVICE_UX_MGR_SUFFIX_KEY = "DeviceUxManager";
    private static final String DEVICE_UX_MGR_SUFFIX_DEFAULT = "Device Ux Manager";
    private static final String N_POINT_MANAGER = "ndriver:NPointManager";
    private static final String POINT_MGR_SUFFIX_KEY = "PointManager";
    private static final String POINT_MGR_SUFFIX_DEFAULT = "Point Manager";
    private static final String N_POINT_UX_MANAGER = "ndriver:NPointUxManager";
    private static final String POINT_UX_MGR_SUFFIX_KEY = "PointUxManager";
    private static final String POINT_UX_MGR_SUFFIX_DEFAULT = "Point Ux Manager";

    public AgentInfoUtil(AgentInfo nAgentInfo, String driverModuleName, String displayNameKey, String displayNameDefault) {
        this.nAgentInfo = nAgentInfo;
        this.driverModuleName = driverModuleName;
        this.displayNameKey = displayNameKey;
        this.displayNameDefault = displayNameDefault;
    }

    public String getAgentId() {
        return this.nAgentInfo.getAgentId();
    }

    public TypeInfo[] getAgentOn() {
        return this.nAgentInfo.getAgentOn();
    }

    public TypeInfo getAgentType() {
        return this.nAgentInfo.getAgentType();
    }

    public String getDisplayName(Context cx) {
        String driverDisplayName;
        if (this.driverModuleName != null && (driverDisplayName = TextUtil.toFriendly((String)this.driverModuleName)) != null) {
            Lexicon driverLex = Lexicon.make((String)this.driverModuleName);
            String suffix = this.displayNameDefault;
            if (driverLex != null) {
                suffix = driverLex.get(this.displayNameKey, this.displayNameDefault);
            }
            return driverDisplayName + ' ' + suffix;
        }
        return this.nAgentInfo.getDisplayName(cx);
    }

    public BIcon getIcon(Context cx) {
        return this.nAgentInfo.getIcon(cx);
    }

    public BObject getInstance() {
        return this.nAgentInfo.getInstance();
    }

    public BPermissions getRequiredPermissions() {
        return this.nAgentInfo.getRequiredPermissions();
    }

    public static AgentList getAgentsHelp(AgentList agents, String driverModuleName, String mgrTypeSpec, String mgrSuffixKey, String mgrSuffixDefault) {
        int i;
        TypeInfo managerTypeInfo = Sys.getRegistry().getType(mgrTypeSpec);
        AgentInfoUtil managerAgentInfo = new AgentInfoUtil(managerTypeInfo.getAgentInfo(), driverModuleName, mgrSuffixKey, mgrSuffixDefault);
        boolean containsExtendedVersionOfMgr = false;
        boolean renamedAgent = false;
        int insertAtIndex = 0;
        for (i = 0; i < agents.size(); ++i) {
            TypeInfo agentTypeInfo = agents.get(i).getAgentType();
            if (!agentTypeInfo.is(managerTypeInfo) || agentTypeInfo.equals(managerTypeInfo)) continue;
            if (mgrTypeSpec.equals(N_DEVICE_MANAGER) || mgrTypeSpec.equals(N_POINT_MANAGER)) {
                agents.add(insertAtIndex, agents.get(i));
                ++insertAtIndex;
            }
            containsExtendedVersionOfMgr = true;
        }
        for (i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().equals(managerTypeInfo)) continue;
            agents.remove(i);
            if (containsExtendedVersionOfMgr) continue;
            agents.add((AgentInfo)managerAgentInfo);
            renamedAgent = true;
        }
        if (!renamedAgent && !containsExtendedVersionOfMgr) {
            agents.add((AgentInfo)managerAgentInfo);
        }
        for (i = agents.size() - 1; i >= 0; --i) {
            if (!agents.get(i).getAgentType().is(BPxView.TYPE)) continue;
            agents.toTop(i);
        }
        return agents;
    }

    public String getAppName() {
        return null;
    }

    public static AgentList processDeviceManagerAgents(AgentList agents, boolean useAutoManager, String moduleName) {
        return useAutoManager ? AgentInfoUtil.renameAutoManagerDeviceAgents(agents, moduleName) : AgentInfoUtil.removeAutoManagerDeviceAgents(agents);
    }

    public static AgentList processPointManagerAgents(AgentList agents, boolean useAutoManager, String moduleName) {
        return useAutoManager ? AgentInfoUtil.renameAutoManagerPointAgents(agents, moduleName) : AgentInfoUtil.removeAutoManagerPointAgents(agents);
    }

    private static AgentList removeAutoManagerDeviceAgents(AgentList agents) {
        agents.remove(N_DEVICE_UX_MANAGER);
        agents.remove(N_DEVICE_MANAGER);
        return agents;
    }

    private static AgentList renameAutoManagerDeviceAgents(AgentList agents, String moduleName) {
        try {
            AgentInfoUtil.getAgentsHelp(agents, moduleName, N_DEVICE_UX_MANAGER, DEVICE_UX_MGR_SUFFIX_KEY, DEVICE_UX_MGR_SUFFIX_DEFAULT);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
        return AgentInfoUtil.getAgentsHelp(agents, moduleName, N_DEVICE_MANAGER, DEVICE_MGR_SUFFIX_KEY, DEVICE_MGR_SUFFIX_DEFAULT);
    }

    private static AgentList removeAutoManagerPointAgents(AgentList agents) {
        agents.remove(N_POINT_MANAGER);
        agents.remove(N_POINT_UX_MANAGER);
        return agents;
    }

    private static AgentList renameAutoManagerPointAgents(AgentList agents, String moduleName) {
        try {
            AgentInfoUtil.getAgentsHelp(agents, moduleName, N_POINT_UX_MANAGER, POINT_UX_MGR_SUFFIX_KEY, POINT_UX_MGR_SUFFIX_DEFAULT);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
        return AgentInfoUtil.getAgentsHelp(agents, moduleName, N_POINT_MANAGER, POINT_MGR_SUFFIX_KEY, POINT_MGR_SUFFIX_DEFAULT);
    }
}

