/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TypedOutputStream
extends ByteArrayOutputStream {
    int bitFieldMark = 0;

    public TypedOutputStream() {
    }

    public TypedOutputStream(int size) {
        super(size);
    }

    public TypedOutputStream(byte[] b) {
        this.buf = b;
        this.count = 0;
    }

    public void writeByteArray(byte[] byteArray) {
        this.write(byteArray, 0, byteArray.length);
    }

    public void writeByteArray(byte[] byteArray, int count) {
        int copyCnt;
        this.write(byteArray, 0, copyCnt);
        for (copyCnt = byteArray.length > count ? count : byteArray.length; copyCnt < count; ++copyCnt) {
            this.write(0);
        }
    }

    public void writeCharArray(String str, int count) {
        char[] a = str.toCharArray();
        for (int i = 0; i < count; ++i) {
            if (i < a.length) {
                this.write(a[i]);
                continue;
            }
            this.write(0);
        }
    }

    public void writeString(String str) {
        char[] a = str.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            this.write(a[i]);
        }
        this.write(0);
    }

    public void writeBooleanBit(boolean val, int byteOffset, int bitOffset, int bitCount) {
        this.writeBit(val ? 1 : 0, byteOffset, bitOffset, bitCount);
    }

    public void writeBit(int val, int byteOffset, int bitOffset, int bitCount) {
        if (bitCount + bitOffset > 32) {
            throw new RuntimeException("bitfield exceeds maximum of 32. " + bitCount + bitOffset);
        }
        int affectedByteCnt = (bitCount + bitOffset - 1) / 8 + 1;
        int finalPos = this.bitFieldMark + byteOffset;
        int startPos = finalPos - affectedByteCnt + 1;
        if (finalPos >= this.buf.length) {
            throw new RuntimeException("OutOfRange byteOffset in readBit. " + byteOffset + ":" + this.count);
        }
        if (startPos < this.bitFieldMark) {
            throw new RuntimeException("Invalid byteOffset/bitcount - would read beyound begining of bit fields.");
        }
        while (this.count <= finalPos) {
            this.write(0);
        }
        int mask = 1;
        while (--bitCount > 0) {
            mask = mask << 1 | 1;
        }
        val &= mask;
        val <<= bitOffset;
        int pos = startPos;
        for (int i = 0; i < affectedByteCnt; ++i) {
            int n = pos++;
            this.buf[n] = (byte)(this.buf[n] | val >> (affectedByteCnt - i - 1) * 8 & 0xFF);
        }
    }

    public void writeSignedBit(int val, int byteOffset, int bitOffset, int bitCount) {
        this.writeBit(val, byteOffset, bitOffset, bitCount);
    }

    public void writeNibble(int val, int byteOffset, boolean upper) {
        this.writeBit(val, byteOffset, upper ? 4 : 0, 4);
    }

    public void writeBoolean(boolean b) {
        this.write(b ? 1 : 0);
    }

    public void writeSigned16(int l) {
        int highByte = l >> 8 & 0xFF;
        int lowByte = l & 0xFF;
        this.write(highByte);
        this.write(lowByte);
    }

    public void writeUnsigned16(int l) {
        int highByte = l >> 8 & 0xFF;
        int lowByte = l & 0xFF;
        this.write(highByte);
        this.write(lowByte);
    }

    public void writeSigned8(int i) {
        this.write(i & 0xFF);
    }

    public void writeUnsigned8(int i) {
        this.write(i & 0xFF);
    }

    public void writeSigned32(int i) {
        this.write((i & 0xFF000000) >> 24);
        this.write((i & 0xFF0000) >> 16);
        this.write((i & 0xFF00) >> 8);
        this.write(i & 0xFF);
    }

    public void writeSigned64(long lval) {
        this.write((int)((lval & 0xFF00000000000000L) >> 56));
        this.write((int)((lval & 0xFF000000000000L) >> 48));
        this.write((int)((lval & 0xFF0000000000L) >> 40));
        this.write((int)((lval & 0xFF00000000L) >> 32));
        this.write((int)((lval & 0xFF000000L) >> 24));
        this.write((int)((lval & 0xFF0000L) >> 16));
        this.write((int)((lval & 0xFF00L) >> 8));
        this.write((int)(lval & 0xFFL));
    }

    public void writeUnsigned32(long i) {
        this.write((int)(i & 0xFFFFFFFFFF000000L) >> 24);
        this.write((int)(i & 0xFF0000L) >> 16);
        this.write((int)(i & 0xFF00L) >> 8);
        this.write((int)(i & 0xFFL));
    }

    public void writeFloat(float value) {
        int bitView = Float.floatToIntBits(value);
        this.write((bitView & 0xFF000000) >> 24);
        this.write((bitView & 0xFF0000) >> 16);
        this.write((bitView & 0xFF00) >> 8);
        this.write(bitView & 0xFF);
    }

    public void writeDouble(double value) {
        long bitView = Double.doubleToLongBits(value);
        this.writeSigned64(bitView);
    }

    public void writeUnsigned8Float(float value, int invalid, int scale) {
        int tmp = (int)(Float.isNaN(value) ? (float)invalid : value * (float)scale);
        this.writeUnsigned8(tmp);
    }

    public void writeUnsigned16Float(float value, int invalid, int scale) {
        int tmp = (int)(Float.isNaN(value) ? (float)invalid : value * (float)scale);
        this.writeUnsigned16(tmp);
    }

    public void writeSigned8Float(float value, int invalid, int scale) {
        int tmp = (int)(Float.isNaN(value) ? (float)invalid : value * (float)scale);
        this.writeSigned8(tmp);
    }

    public void writeSigned16Float(float value, int invalid, int scale) {
        int tmp = (int)(Float.isNaN(value) ? (float)invalid : value * (float)scale);
        this.writeSigned16(tmp);
    }

    public int setBitFieldMark() {
        int orig = this.bitFieldMark;
        this.bitFieldMark = this.count;
        return orig;
    }

    public void resetBitFieldMark(int orig) {
        this.bitFieldMark = orig;
    }

    public void setPosition(int position) {
        while (this.count < position) {
            this.write(0);
        }
    }

    public void toOutputStream(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

