/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.io;

import java.io.ByteArrayInputStream;
import javax.baja.sys.BajaRuntimeException;

public class TypedInputStream
extends ByteArrayInputStream {
    int bitFieldMark = 0;

    public TypedInputStream(byte[] buf) {
        super(buf);
    }

    public TypedInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public boolean readBoolean() {
        return this.read() != 0;
    }

    public int readSigned32() {
        int byte3 = this.read() & 0xFF;
        int byte2 = this.read() & 0xFF;
        int byte1 = this.read() & 0xFF;
        int byte0 = this.read() & 0xFF;
        return byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0;
    }

    public long readSigned64() {
        long v = this.read();
        for (int i = 0; i < 7; ++i) {
            v = v << 8 | (long)this.read();
        }
        return v;
    }

    public long readUnsigned32() {
        long byte3 = this.read() & 0xFF;
        long byte2 = this.read() & 0xFF;
        long byte1 = this.read() & 0xFF;
        long byte0 = this.read() & 0xFF;
        return (byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0) & 0xFFFFFFFFFFFFFFFFL;
    }

    public int readUnsigned16() {
        int highByte = this.read() & 0xFF;
        int lowByte = this.read() & 0xFF;
        return highByte << 8 | lowByte;
    }

    public int readSigned16() {
        int highByte = this.read();
        int lowByte = this.read() & 0xFF;
        boolean signBit = false;
        int temp = 0;
        if ((highByte & 0x80) != 0) {
            signBit = true;
        }
        temp = highByte << 8 | lowByte;
        if (signBit) {
            return temp | 0xFFFF0000;
        }
        return temp;
    }

    public int readSigned8() {
        int highByte = this.read();
        if ((highByte & 0x80) != 0) {
            return highByte | 0xFFFFFF00;
        }
        return highByte;
    }

    public int readUnsigned8() {
        return this.read() & 0xFF;
    }

    public int readBit(int byteOffset, int bitOffset, int bitCount) {
        if (byteOffset >= this.count || byteOffset < 0) {
            throw new RuntimeException("OutOfRange byteOffset in readBit. " + byteOffset + ":" + this.count);
        }
        if (bitCount + bitOffset > 32) {
            throw new RuntimeException("bitCount exceeds maximum of 32. " + bitCount);
        }
        int extraByteCnt = (bitCount + bitOffset - 1) / 8;
        if (byteOffset - extraByteCnt < 0) {
            throw new RuntimeException("Invalid byteOffset/bitcount - would read beyound begining of bit fields.");
        }
        this.pos = this.bitFieldMark + byteOffset - extraByteCnt;
        int b = this.read();
        for (int i = 0; i < extraByteCnt; ++i) {
            b = b << 8 | this.read();
        }
        b >>= bitOffset;
        int mask = 1;
        while (--bitCount > 0) {
            mask = mask << 1 | 1;
        }
        return b & mask;
    }

    public int readSignedBit(int byteOffset, int bitOffset, int bitCount) {
        int signBit;
        int n = this.readBit(byteOffset, bitOffset, bitCount);
        if ((n & (signBit = 1 << bitCount - 1)) == 0) {
            return n;
        }
        int mask = 0;
        for (int i = 1; i < bitCount; ++i) {
            mask = (mask << 1) + 1;
        }
        return (n & mask) - signBit;
    }

    public int readNibble(int byteOffset, boolean upper) {
        return this.readBit(byteOffset, upper ? 4 : 0, 4);
    }

    public int readSignedNibble(int byteOffset, boolean upper) {
        return this.readSignedBit(byteOffset, upper ? 4 : 0, 4);
    }

    public boolean readBooleanBit(int byteOffset, int bitOffset, int bitCount) {
        int val = this.readBit(byteOffset, bitOffset, bitCount);
        return val > 0;
    }

    public String readString() {
        char c8;
        StringBuffer sb = new StringBuffer();
        while ((c8 = (char)this.read()) != '\u0000') {
            sb.append(c8);
        }
        return sb.toString();
    }

    public String readCharArray(int len) {
        if (len > this.available()) {
            len = this.available();
        }
        StringBuffer sb = new StringBuffer();
        boolean terminated = false;
        for (int i = 0; i < len; ++i) {
            char c8 = (char)this.read();
            if (c8 == '\u0000') {
                terminated = true;
            }
            if (terminated) continue;
            sb.append(c8);
        }
        return sb.toString();
    }

    public byte[] readByteArray(int len) {
        if (len > this.available()) {
            len = this.available();
        }
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = (byte)this.read();
        }
        return a;
    }

    public byte[] readByteArray() {
        return this.readByteArray(this.available());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readSigned32());
    }

    public double readDouble() {
        long v = this.read();
        for (int i = 0; i < 7; ++i) {
            v = v << 8 | (long)this.read();
        }
        return Double.longBitsToDouble(v);
    }

    public float readUnsigned8Float(int invalid, int scale) {
        int tmp = this.readUnsigned8();
        return tmp != invalid ? (float)(tmp / scale) : Float.NaN;
    }

    public float readUnsigned16Float(int invalid, int scale) {
        int tmp = this.readUnsigned16();
        return tmp != invalid ? (float)(tmp / scale) : Float.NaN;
    }

    public float readSigned8Float(int invalid, int scale) {
        int tmp = this.readSigned8();
        return tmp != invalid ? (float)(tmp / scale) : Float.NaN;
    }

    public float readSigned16Float(int invalid, int scale) {
        int tmp = this.readSigned16();
        return tmp != invalid ? (float)(tmp / scale) : Float.NaN;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    public void reset(int position) {
        this.pos = position;
    }

    public int setBitFieldMark() {
        int orig = this.bitFieldMark;
        this.bitFieldMark = this.pos;
        return orig;
    }

    public void resetBitFieldMark(int orig) {
        this.bitFieldMark = orig;
    }

    public int position() {
        return this.pos;
    }

    @Override
    public int read() {
        if (this.pos >= this.count) {
            throw new BajaRuntimeException("end of buf encountered");
        }
        return super.read();
    }
}

