/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.discover;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BNDiscoveryJob
extends BJob {
    public static final Property discoveryFolder = BNDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property discoveryPreferences = BNDiscoveryJob.newProperty((int)0, (BValue)new BNDiscoveryPreferences(), null);
    public static final Type TYPE = Sys.loadType(BNDiscoveryJob.class);
    public static final Lexicon LEX = Lexicon.make(BNDiscoveryJob.class);
    private BINDiscoveryHost discoveryHost = null;
    private Exception jobException = null;
    private JobThread thread;

    public BOrd getDiscoveryFolder() {
        return (BOrd)this.get(discoveryFolder);
    }

    public void setDiscoveryFolder(BOrd v) {
        this.set(discoveryFolder, (BValue)v, null);
    }

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNDiscoveryJob() {
    }

    public BNDiscoveryJob(BINDiscoveryHost databaseParent) {
        this.discoveryHost = databaseParent;
    }

    public void doRun(Context cx) {
        this.thread = new JobThread(this.toPathString(), cx);
        this.thread.start();
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public String toString(Context cx) {
        BModule mod = this.getDiscoveryPreferences().getType().getModule();
        String lexKey = this.getDiscoveryPreferences().getType().getTypeName() + ".discovery.jobBar.name";
        String driverName = mod.getLexicon().get(lexKey);
        if (driverName == null || driverName.length() == 0) {
            driverName = mod.getModuleName();
            driverName = TextUtil.toFriendly((String)driverName) + ' ' + LEX.getText("Discovery");
        }
        return driverName;
    }

    protected void end() {
        if (this.jobException != null) {
            this.failed(this.jobException);
        } else if (this.isCanceled()) {
            this.canceled();
        } else {
            this.success();
        }
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    public void discoverFail(String reason) {
        this.log().message(reason);
    }

    public void discoverOk(BINDiscoveryObject[] discoveryObjects) {
        if (discoveryObjects == null) {
            return;
        }
        for (int i = 0; i < discoveryObjects.length; ++i) {
            this.addDiscoveryObject(discoveryObjects[i]);
        }
    }

    public void addDiscoveryObject(BINDiscoveryObject discoveryObject) {
        if (discoveryObject == null) {
            return;
        }
        BINDiscoveryObject[] objs = this.getRootDiscoveryObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!objs[i].equivalent(discoveryObject)) continue;
            return;
        }
        this.discoveryFolder().add("d?", (BValue)discoveryObject);
    }

    public BINDiscoveryObject[] getRootDiscoveryObjects() {
        return (BINDiscoveryObject[])this.discoveryFolder().getChildren(BINDiscoveryObject.class);
    }

    protected void clearRootDiscoveryObjects() {
        this.discoveryFolder().removeAll();
    }

    public BComponent discoveryFolder() {
        BOrd disOrd = this.getDiscoveryFolder();
        BNDiscoveryJob fldr = null;
        if (!disOrd.isNull()) {
            fldr = (BComponent)disOrd.get((BObject)this);
        }
        return fldr != null ? fldr : this;
    }

    class JobThread
    extends Thread {
        Context cx;

        JobThread(String name, Context cx) {
            super(name);
            this.cx = cx;
        }

        @Override
        public void run() {
            BNDiscoveryJob.this.clearRootDiscoveryObjects();
            try {
                BNDiscoveryPreferences prefs = BNDiscoveryJob.this.getDiscoveryPreferences();
                prefs.job = BNDiscoveryJob.this;
                boolean done = false;
                while (!done) {
                    BINDiscoveryObject[] discoveryObjects = BNDiscoveryJob.this.discoveryHost.getDiscoveryObjects(prefs);
                    BNDiscoveryJob.this.discoverOk(discoveryObjects);
                    if (prefs.isMultiStep() && discoveryObjects != null && BNDiscoveryJob.this.getJobState().isRunning()) continue;
                    done = true;
                }
            }
            catch (Exception e) {
                BNDiscoveryJob.this.jobException = e;
            }
            BNDiscoveryJob.this.end();
        }
    }
}

