/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.datatypes;

import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BSpyReset;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCommConfig
extends BComponent {
    public static final Property faultCause = BCommConfig.newProperty((int)67, (String)"", null);
    public static final Property statisticsReset = BCommConfig.newProperty((int)7, (BValue)new BSpyReset(), null);
    public static final Type TYPE = Sys.loadType(BCommConfig.class);
    IMessageFactory fac = null;
    NLinkMessageFactory lnkFac = null;
    private static final BIcon icon = BIcon.std((String)"gears.png");
    Exception startExp = null;
    IComm comm = null;
    protected ICommListener defaultListener = null;
    boolean commStarted = false;

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BSpyReset getStatisticsReset() {
        return (BSpyReset)this.get(statisticsReset);
    }

    public void setStatisticsReset(BSpyReset v) {
        this.set(statisticsReset, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        if (this.commStarted) {
            return;
        }
        if (!this.okayToRun()) {
            this.setFault(this.getStatusFault(), false);
            return;
        }
        this.init();
        this.commStarted = true;
        this.ccStarted();
    }

    public final void stopped() throws Exception {
        if (this.comm != null) {
            this.comm.stop();
        }
        this.ccStopped();
        this.commStarted = false;
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == faultCause) {
            return;
        }
        if (this.comm != null) {
            try {
                this.comm.verifySettings(this);
                this.clearFault();
            }
            catch (Exception e) {
                this.setFault(e, true);
                throw new LocalizableRuntimeException("ndriver", "commConfig.configError", (Throwable)e);
            }
        }
        this.ccChanged(p, cx);
    }

    public void ccStarted() {
    }

    public void ccStopped() {
    }

    public void ccChanged(Property p, Context cx) {
    }

    public IComm createComm() {
        return new NComm(this, this.defaultListener);
    }

    public final IComm comm() {
        if (this.comm == null) {
            try {
                this.started();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startExp != null) {
            throw new BajaRuntimeException("Comm error", (Throwable)this.startExp);
        }
        return this.comm;
    }

    private void init() {
        try {
            if (this.comm == null) {
                this.comm = this.createComm();
            }
            this.comm.start();
            this.clearFault();
        }
        catch (Exception e) {
            this.setFault(e, true);
        }
    }

    private void clearFault() {
        this.setFaultCause("");
        if (this.startExp != null) {
            this.startExp = null;
            this.notifyParent();
        }
    }

    private void setFault(Exception e, boolean configFault) {
        this.startExp = e;
        this.setFaultCause(e.getMessage());
        if (configFault) {
            this.notifyParent();
        }
    }

    private void notifyParent() {
        BComponent c = this.getParent().asComponent();
        if (c == null) {
            return;
        }
        c.changed(this.getPropertyInParent(), null);
    }

    public final void statusUpdate() {
        boolean ok2Run = this.okayToRun();
        if (!ok2Run && this.commStarted) {
            try {
                this.stopped();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setFault(this.getStatusFault(), false);
        } else if (ok2Run && !this.commStarted) {
            try {
                this.started();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean okayToRun() {
        if (!(this.getParent() instanceof BIStatus)) {
            return true;
        }
        BStatus st = ((BIStatus)this.getParent()).getStatus();
        return !st.isDisabled() && !st.isFault();
    }

    private Exception getStatusFault() {
        BStatus st = ((BIStatus)this.getParent()).getStatus();
        if (st.isFault()) {
            return new BajaRuntimeException("Comm error: parent in fault");
        }
        return new BajaRuntimeException("Comm error: parent is disabled");
    }

    public void setDefaultListener(ICommListener listener) {
        this.defaultListener = listener;
        if (this.comm != null) {
            this.comm.setDefaultListener(listener);
        }
    }

    public final IMessageFactory getMessageFactory() {
        if (this.fac == null) {
            this.fac = this.makeMessageFactory();
        }
        return this.fac;
    }

    protected IMessageFactory makeMessageFactory() {
        return new IMessageFactory(){

            @Override
            public NMessage makeMessage(LinkMessage lm) throws Exception {
                NMessage nmsg = new NMessage((BAddress)((Object)lm.address));
                nmsg.fromInputStream(lm.getInputStream());
                return nmsg;
            }
        };
    }

    public ILinkLayer makeLinkLayer(NComm comm) {
        throw new BajaRuntimeException("Not Implemented: Must implement specific comm config object");
    }

    public int getMaxOutstandingTransactions() {
        return 32;
    }

    public int getMaxTransactionWait() {
        return 30;
    }

    public final NLinkMessageFactory getLinkMessageFactory() {
        if (this.lnkFac == null) {
            this.lnkFac = this.makeLinkMessageFactory();
        }
        return this.lnkFac;
    }

    protected NLinkMessageFactory makeLinkMessageFactory() {
        return new NLinkMessageFactory(32, 1500);
    }

    public String getResourcePrefix() {
        String n;
        BComplex p;
        for (p = this.getParent(); p != null && !p.getType().is(BNNetwork.TYPE); p = p.getParent()) {
        }
        if (p != null) {
            n = ((BNNetwork)p).getNetworkName();
        } else {
            n = this.getParent().getClass().getName();
            if (n.indexOf(46) >= 0) {
                n = n.substring(n.lastIndexOf(46) + 1);
            }
        }
        return n;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (this.comm == null && this.startExp == null) {
            out.thTitle((Object)"Comm stack not initialized.");
            return;
        }
        out.startProps("Comm Config");
        out.prop((Object)"okayToRun", this.okayToRun());
        out.prop((Object)"commStarted", this.commStarted);
        out.prop((Object)"defaultListener", (Object)(this.defaultListener != null ? this.defaultListener.getClass().getName() : "null"));
        out.endProps();
        if (this.startExp != null) {
            out.startProps("start exception");
            Throwable e = this.startExp;
            while (e != null) {
                out.tr((Object)e.toString());
                if (e instanceof BajaException) {
                    e = ((BajaException)e).getCause();
                    continue;
                }
                if (!(e instanceof BajaRuntimeException)) break;
                e = ((BajaRuntimeException)e).getCause();
            }
            out.endProps();
        } else if (this.comm != null) {
            this.comm.spy(out);
            this.resetRef(out);
        }
    }

    private void resetRef(SpyWriter out) {
        out.startTable(false).tr().td().w((Object)"<b>").a(out.getPath().getBody() + "/statisticsReset", (Object)"reset statistics").w((Object)"</b>").endTd().endTr().endTable();
    }

    public void spyReset() {
        if (this.comm != null) {
            this.comm.resetStats();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

