/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;

public class NHttpMessage
extends NMessage {
    Array<NVPair> headerFields = new Array(NVPair.class);
    byte[] buf = null;
    private static final List<String> HEADERS_TO_REDACT = Collections.unmodifiableList(Arrays.asList("authorization", "cookie", "proxy-authorization"));

    public NHttpMessage(BIpAddress address) {
        super(address);
    }

    public void addHeader(String name, String value) {
        NVPair nvp = this.findPair(name);
        if (nvp != null) {
            nvp.value = value;
        } else {
            this.headerFields.add((Object)new NVPair(name, value));
        }
    }

    public NVPair[] getHeaders() {
        return (NVPair[])this.headerFields.trim();
    }

    public byte[] getData() {
        return this.buf;
    }

    public String getValue(String name) {
        NVPair nvp = this.findPair(name);
        if (nvp == null) {
            return null;
        }
        return nvp.value;
    }

    private NVPair findPair(String name) {
        NVPair[] a = (NVPair[])this.headerFields.array();
        int len = this.headerFields.size();
        for (int i = 0; i < len; ++i) {
            if (!a[i].name.equalsIgnoreCase(name)) continue;
            return a[i];
        }
        return null;
    }

    @Override
    public String toTraceString() {
        NVPair[] a = (NVPair[])this.headerFields.array();
        int len = this.headerFields.size();
        StringWriter sw = new StringWriter();
        StringBuffer sb = sw.getBuffer();
        for (int i = 0; i < len; ++i) {
            NVPair pair = a[i];
            sb.append(pair.name).append(": ");
            if (HEADERS_TO_REDACT.contains(pair.name.toLowerCase(Locale.ENGLISH))) {
                sb.append("********");
            } else {
                sb.append(pair.value);
            }
            sb.append('\n');
        }
        if (this.buf != null && this.buf.length > 0) {
            ByteArrayUtil.hexDump((PrintWriter)new PrintWriter(sw), (byte[])this.buf, (int)0, (int)this.buf.length);
        }
        return sw.toString();
    }

    public static class NVPair {
        public String name;
        public String value;

        public NVPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

