/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.http.AuthUtil;
import com.tridium.ndriver.comm.http.NHttpErrorResponse;
import com.tridium.ndriver.comm.http.NHttpMessage;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BHttpCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SpyUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpComm
implements IComm {
    private Logger log;
    private BHttpCommConfig comCfg;
    private boolean done = true;
    private Statistics stats = new Statistics();
    Hashtable<String, LinkSession> sessions = new Hashtable(30);
    AuthUtil auth = new AuthUtil();
    Thread rcvThread;

    public HttpComm(BHttpCommConfig comCfg, ICommListener defaultListener) {
        this.comCfg = comCfg;
    }

    @Override
    public void start() throws Exception {
        this.log().fine("start HttpComm");
        this.done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.done = true;
        Enumeration<LinkSession> en = this.sessions.elements();
        while (en.hasMoreElements()) {
            LinkSession t;
            LinkSession linkSession = t = en.nextElement();
            synchronized (linkSession) {
                t.close();
                t.notify();
            }
        }
        this.sessions.clear();
    }

    @Override
    public void verifySettings(BCommConfig comCfg) throws Exception {
    }

    @Override
    public void setDefaultListener(ICommListener listener) {
    }

    public NHttpResponse sendRequest(NHttpRequest msg) throws Exception {
        if (this.done) {
            return null;
        }
        String key = msg.getAddress().toString();
        LinkSession ls = this.sessions.get(key);
        if (ls == null) {
            ls = new LinkSession((BIpAddress)msg.getAddress());
            this.log().fine("new LinkSession for " + key);
            this.sessions.put(key, ls);
        }
        int retry = msg.getRetryCount();
        while (true) {
            try {
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().fine("sendRequest to " + key + "\n" + msg.toTraceString());
                }
                NHttpResponse resp = (NHttpResponse)ls.doSend(msg, false);
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().fine("response from " + key + "\n" + resp.toTraceString());
                }
                ++this.stats.msgSent;
                return resp;
            }
            catch (Exception e) {
                if (retry-- > 0) continue;
                throw e;
            }
            break;
        }
    }

    public NHttpStream openStream(NHttpRequest msg) throws Exception {
        if (this.done) {
            return null;
        }
        LinkSession ls = new LinkSession((BIpAddress)msg.getAddress());
        NHttpStream strm = (NHttpStream)ls.doSend(msg, true);
        ++this.stats.openStreamReq;
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine("openStream to " + (Object)((Object)msg.getAddress()) + "\n" + msg.toTraceString());
        }
        return strm;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps("HttpComm");
        out.prop((Object)"done", this.done);
        out.prop((Object)"number of linkSessions", this.sessions.size());
        out.endProps();
        this.auth.spy(out);
        SpyUtil.spy(out, "HttpComm Statistics", this.stats);
    }

    @Override
    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.comCfg.getResourcePrefix() + ".HttpComm");
        }
        return this.log;
    }

    public static class Statistics {
        long startTime = Clock.millis();
        public long msgSent = 0L;
        public long openStreamReq = 0L;
        public long streamsOpened = 0L;
        public long msgReceived = 0L;
        public long errorResponses = 0L;

        public String getStartTime() {
            return BAbsTime.make((long)this.startTime).toLocalTime().toString(null);
        }
    }

    private class LinkSession {
        HttpConnection httpConn = null;

        LinkSession(BIpAddress tcpAdr) throws Exception {
        }

        NHttpMessage doSend(NHttpRequest msg, boolean streamReq) throws Exception {
            try {
                NHttpResponse resp;
                BIpAddress ipAdr = (BIpAddress)msg.getAddress();
                boolean send = true;
                boolean firstPass = true;
                while (send) {
                    if (this.httpConn == null) {
                        if (HttpComm.this.comCfg.getUseTls()) {
                            SSLSocketFactory defaultFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                            this.httpConn = new HttpsConnection((BHost)new BIpHost(ipAdr.getIpAddress()), ipAdr.getPort(), null, (SocketFactory)defaultFactory);
                        } else {
                            this.httpConn = new HttpConnection((BHost)new BIpHost(ipAdr.getIpAddress()), ipAdr.getPort());
                        }
                    }
                    HttpComm.this.auth.addAuthorization(msg, HttpComm.this.log);
                    this.httpConn.setTimeout(msg.getResponseTimeOut());
                    this.httpConn.setConnectionTimeout(HttpComm.this.comCfg.getConnectionTimeout());
                    this.httpConn.setRequestMethod(msg.getMethod());
                    NHttpMessage.NVPair[] a = msg.getHeaders();
                    for (int i = 0; i < a.length; ++i) {
                        this.httpConn.setRequestHeader(a[i].name, a[i].value);
                    }
                    String uri = msg.getUri();
                    byte[] buf = msg.getData();
                    int rc = buf == null ? this.httpConn.newRequest(uri) : this.httpConn.newRequest(msg.getUri(), (long)buf.length, (InputStream)new ByteArrayInputStream(buf));
                    if (rc == 200 || msg.isValidResponse(rc)) {
                        send = false;
                        continue;
                    }
                    NHttpErrorResponse rsp = new NHttpErrorResponse(ipAdr, this.httpConn, rc);
                    ++((HttpComm)HttpComm.this).stats.errorResponses;
                    if (rc != 401 || !firstPass || !HttpComm.this.auth.receiveChallenge(msg, rsp, HttpComm.this.log)) {
                        throw new NCommException("Error " + rc + ":" + rsp.getErrorMessage());
                    }
                    firstPass = false;
                    this.httpConn.close();
                }
                if (streamReq) {
                    resp = new NHttpStream(ipAdr, this.httpConn);
                    ++((HttpComm)HttpComm.this).stats.streamsOpened;
                } else {
                    resp = new NHttpResponse(ipAdr, this.httpConn);
                    ++((HttpComm)HttpComm.this).stats.msgReceived;
                }
                if (!streamReq) {
                    if (this.httpConn.shouldClose() || msg.closeConn()) {
                        this.httpConn.close();
                    }
                    if (this.httpConn.shouldClose()) {
                        this.httpConn = null;
                    }
                }
                NHttpResponse nHttpResponse = resp;
                return nHttpResponse;
            }
            catch (Exception e) {
                this.close();
                this.httpConn = null;
                throw e;
            }
        }

        void close() {
            if (this.httpConn != null) {
                this.httpConn.close();
            }
        }
    }
}

