/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.http.NHttpErrorResponse;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;

class AuthUtil {
    Map<String, Authenticate> hash = Collections.synchronizedMap(new LinkedHashMap());
    ArrayList<String> keyTableWithoutPass = new ArrayList<String>(){};
    Random clientRandom = new SecureRandom();
    private static final boolean PASSWORD_OPTION = true;
    private static final boolean NO_PASSWORD_OPTION = false;

    AuthUtil() {
    }

    boolean receiveChallenge(NHttpRequest req, NHttpErrorResponse err, Logger log) {
        if (req.getUsernamePassword() == null) {
            return false;
        }
        String authS = err.getValue("www-authenticate");
        if (authS == null) {
            return false;
        }
        String key = this.getHashKey(req, true);
        String keyWithoutPassword = this.getHashKey(req, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("receiveChallenge - add auth for " + keyWithoutPassword);
        }
        AuthParams ap = new AuthParams(authS);
        Authenticate auth = this.hash.get(key);
        if (auth != null && log.isLoggable(Level.FINE)) {
            log.fine("Replace authentication info \n" + auth.params.getValue("nonce") + "\n" + ap.getValue("nonce"));
        }
        auth = new Authenticate(ap);
        int current = this.hash.size();
        this.hash.put(key, auth);
        if (this.hash.size() > current) {
            this.keyTableWithoutPass.add(keyWithoutPassword);
        }
        return true;
    }

    boolean addAuthorization(NHttpRequest req, Logger log) {
        if (req.getUsernamePassword() == null) {
            return false;
        }
        String key = this.getHashKey(req, true);
        String keyWithoutPassword = this.getHashKey(req, false);
        Authenticate auth = this.hash.get(key);
        if (auth == null) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("addAuthorization for " + keyWithoutPassword + "\nscheme:" + auth.params.scheme);
        }
        try {
            if (auth.params.scheme.equalsIgnoreCase("Digest")) {
                return this.addDigestAuthorization(req, auth);
            }
            if (auth.params.scheme.equalsIgnoreCase("Basic")) {
                BUsernameAndPassword unpw = req.getUsernamePassword();
                req.addBasicAuthorization(unpw.getUsername(), AccessController.doPrivileged(() -> ((BPassword)unpw.getPassword()).getValue()));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean addDigestAuthorization(NHttpRequest req, Authenticate auth) throws Exception {
        BUsernameAndPassword usPass = req.getUsernamePassword();
        String uri = req.getUri();
        String realm = auth.params.getValue("realm");
        String nonce = auth.params.getValue("nonce");
        String qop = auth.params.getValue("qop");
        String opaque = auth.params.getValue("opaque");
        if (nonce == null) {
            return false;
        }
        String cnonce = this.getCnonce(auth, req);
        StringBuffer sb = new StringBuffer();
        sb.append("Digest ");
        sb.append("username=").append(this.quote(usPass.getUsername())).append(", ");
        sb.append("realm=").append(realm).append(", ");
        sb.append("nonce=").append(nonce).append(", ");
        if (opaque != null) {
            sb.append("opaque=").append(opaque).append(", ");
        }
        sb.append("uri=").append(this.quote(uri)).append(", ");
        String ncS = "00000000" + Integer.toHexString(++auth.nc);
        ncS = ncS.substring(ncS.length() - 8);
        if (qop != null) {
            sb.append("nc=").append(ncS).append(", ");
            sb.append("qop=").append(this.unquote(qop)).append(", ");
            sb.append("cnonce=").append(this.quote(cnonce)).append(", ");
        }
        StringBuffer respS = new StringBuffer();
        respS.append(this.hexMD5(usPass.getUsername() + ':' + this.unquote(realm) + ':' + AccessController.doPrivileged(() -> ((BPassword)usPass.getPassword()).getValue()))).append(':');
        respS.append(this.unquote(nonce)).append(':');
        respS.append(ncS).append(':');
        respS.append(cnonce).append(':');
        respS.append(this.unquote(qop)).append(':');
        respS.append(this.hexMD5(req.getMethod() + ':' + uri));
        sb.append("response=").append(this.quote(this.hexMD5(respS.toString())));
        req.addHeader("Authorization", sb.toString());
        return true;
    }

    private String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    private String quote(String s) {
        return '\"' + s + '\"';
    }

    private String getCnonce(Authenticate auth, NHttpRequest req) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BIpAddress adr = (BIpAddress)req.getAddress();
        out.writeUTF("cnonce");
        out.writeInt(auth.nc);
        out.writeUTF(adr.getIpAddress());
        out.writeInt(adr.getPort());
        out.writeLong(System.currentTimeMillis());
        out.writeInt(this.clientRandom.nextInt());
        return this.hexMD5(new String(bout.toByteArray()));
    }

    private String hexMD5(String in) throws Exception {
        StringBuffer result = new StringBuffer();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] toHash = md5.digest(in.getBytes());
        for (int i = 0; i < toHash.length; ++i) {
            result.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)toHash[i])));
        }
        return result.toString();
    }

    private String getHashKey(NHttpRequest req, boolean passwordOption) {
        String uri = req.getUri();
        BUsernameAndPassword usPass = req.getUsernamePassword();
        BIpAddress ip = (BIpAddress)req.getAddress();
        String uriChanged = uri;
        if (-1 != uri.indexOf(63)) {
            uriChanged = uri.substring(0, uri.indexOf(63));
        }
        String ipAddress = ip.getIpAddress();
        String userName = usPass.getUsername();
        String passValue = usPass.getPassword().getValue();
        return passwordOption ? ipAddress + ":" + uriChanged + ":" + userName + ":" + passValue : ipAddress + ":" + uriChanged + ":" + userName + ":****";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("AuthUtil");
        out.endProps();
        if (this.hash.size() <= 0) {
            out.write("<b>no sessions</b><br><br>");
            return;
        }
        out.startTable(true);
        out.trTitle((Object)"sessions", 3);
        Enumeration<String> it = Collections.enumeration(this.hash.keySet());
        Enumeration<String> itSet = Collections.enumeration(this.keyTableWithoutPass);
        Map<String, Authenticate> map = this.hash;
        synchronized (map) {
            while (it.hasMoreElements()) {
                String key = it.nextElement();
                Authenticate c = this.hash.get(key);
                out.w((Object)"<tr><th scope='rowgroup' colspan='3'>").safe((Object)itSet.nextElement()).w((Object)"</th></tr>\n");
                c.params.spy(out);
            }
        }
        out.endTable();
    }

    static class AuthParams {
        String scheme;
        String[] nam;
        String[] val;

        AuthParams(String s) {
            int ndx = s.indexOf(32);
            this.scheme = s.substring(0, ndx);
            StringTokenizer st = new StringTokenizer(s.substring(ndx + 1), ",");
            int cnt = st.countTokens();
            this.nam = new String[cnt];
            this.val = new String[cnt];
            for (int i = 0; i < cnt; ++i) {
                String tok = st.nextToken().trim();
                ndx = tok.indexOf(61);
                this.nam[i] = tok.substring(0, ndx);
                this.val[i] = tok.substring(ndx + 1);
            }
        }

        String getValue(String tok) {
            for (int i = 0; i < this.nam.length; ++i) {
                if (!this.nam[i].equals(tok)) continue;
                return this.val[i];
            }
            return null;
        }

        void spy(SpyWriter out) {
            for (int i = 0; i < this.nam.length; ++i) {
                out.w((Object)"<tr>");
                out.td((Object)(i == 0 ? this.scheme : ""));
                out.td((Object)this.nam[i]).td((Object)this.val[i]);
                out.w((Object)"</tr>\n");
            }
        }
    }

    static class Authenticate {
        AuthParams params;
        int nc = 1;

        Authenticate(AuthParams p) {
            this.params = p;
        }
    }
}

