/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Sys;

public class ModuleSecurityInfoProvider {
    private final JarSignatureRegistry signatureRegistry;
    private final ISecurityInfoProvider secInfoProvider;
    private final CertificateChainValidator certValidator = new CertificateChainValidator();
    protected static final Logger LOGGER = Logger.getLogger("securityDashboard");

    public ModuleSecurityInfoProvider() {
        this(Nre.getJarSignatureRegistry(), AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider()));
    }

    public ModuleSecurityInfoProvider(JarSignatureRegistry signatureRegistry, ISecurityInfoProvider secInfoProvider) {
        this.signatureRegistry = signatureRegistry;
        this.secInfoProvider = secInfoProvider;
    }

    protected EnumMap<ModuleSignatureStatusEnum, List<String>> makeModuleStatusMap() {
        CoreCryptoManager cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)this.secInfoProvider);
        this.certValidator.rebuildTrustAnchors((ICoreCryptoManager)cryptoManager);
        EnumMap<ModuleSignatureStatusEnum, List<String>> statusMap = new EnumMap<ModuleSignatureStatusEnum, List<String>>(ModuleSignatureStatusEnum.class);
        this.signatureRegistry.checkReload();
        Object[] modules = Sys.getRegistry().getModules();
        SortUtil.sort((Object[])modules, (Object[])modules, Comparator.comparing(ModuleInfo::getModulePartName));
        for (Object module : modules) {
            try {
                File file = Nre.bootEnv.findModuleFile(module.getModuleName(), module.getRuntimeProfile().name());
                List signers = this.signatureRegistry.getCodeSigners(file);
                String signatureError = this.signatureRegistry.getSignatureFailureCause(file);
                List statuses = ModuleSignatureStatusEnum.getSignatureStatus((List)signers, (String)signatureError, (CertificateChainValidator)this.certValidator);
                for (ModuleSignatureStatusEnum status : statuses) {
                    statusMap.computeIfAbsent(status, k -> new ArrayList()).add(module.getModulePartName());
                }
            }
            catch (Exception e) {
                LOGGER.warning("Failed to check module signature: " + e);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Cause:", e);
            }
        }
        this.signatureRegistry.save();
        return statusMap;
    }
}

