/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.json.JSONObject;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nss.dashboard.BFoxSecurityDashboardChannel;
import com.tridium.nss.dashboard.BSecurityDashboardDataImport;
import com.tridium.nss.dashboard.DashboardException;
import com.tridium.nss.dashboard.DashboardNotSupportedException;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.entityIo.json.JsonEntityEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.Context;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;

public final class FoxRemoteDashboardDataRetriever
implements IRemoteDashboardDataRetriever,
BFoxClientConnection.Interest {
    private static final Version VER_4_8 = new Version("4.8");
    private static final Logger LOGGER = Logger.getLogger("securityDashboard");
    private static final LexiconModule LEX_MOD = LexiconModule.make((String)"nss");
    private final BSecurityDashboardDataImport importDescriptor;

    public FoxRemoteDashboardDataRetriever(BSecurityDashboardDataImport importDescriptor) {
        this.importDescriptor = importDescriptor;
    }

    @Override
    public JSONObject getRemoteDashboardData(Context cx) throws DashboardException {
        if (!this.importDescriptor.isRunning()) {
            return null;
        }
        if (this.getRemoteVersion().compareTo(VER_4_8) < 0) {
            throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteVersionUnsupported", null));
        }
        BNiagaraStation niagaraStation = this.getNiagaraStation();
        try {
            boolean hasEnabledSecurityService;
            BOrdList queries;
            try {
                niagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
            }
            catch (Exception e) {
                String message = LEX_MOD.getText("foxDataRetriever.connectionFailed", null, new Object[]{e.getMessage()});
                LOGGER.log(Level.FINE, message, e);
                throw new DashboardException(message, e);
            }
            BSysChannel sysChannel = this.getSysChannel();
            boolean remoteNss = true;
            try {
                String key = "nss";
                byte[] versionBytes = sysChannel.stationCall("module.version", key.getBytes());
                remoteNss = !"0".equals(new String(versionBytes));
            }
            catch (Exception key) {
                // empty catch block
            }
            if (!remoteNss) {
                throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteStationHasNoNss", null));
            }
            try {
                BOrd query = BOrd.make((String)"station:|slot:/Services|bql:select * from nss:SecurityService where enabled = true");
                queries = BOrdList.make((BOrd)query);
                Stream remoteEntities = this.getDataChannel().resolveEntities(queries, -1, 1, JsonEntityEncoder.NO_TAGS_OR_RELATIONS, null, null);
                hasEnabledSecurityService = remoteEntities.findFirst().isPresent();
            }
            catch (Exception e) {
                hasEnabledSecurityService = true;
                LOGGER.log(Level.FINE, "Could not determine if remote station has an enabled SecurityService", e);
            }
            if (!hasEnabledSecurityService) {
                throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteStationHasNoSecurityService", null));
            }
            BFoxSecurityDashboardChannel foxChannel = this.getFoxChannel();
            if (foxChannel == null) {
                throw new DashboardException(LEX_MOD.get("foxDataRetriever.noDashboardChannelFound", null));
            }
            try {
                queries = foxChannel.getStationDashboardInfo();
                return queries;
            }
            catch (Exception e) {
                String message = LEX_MOD.getText("foxDataRetriever.retrievalFailed", null, new Object[]{e.getMessage()});
                LOGGER.log(Level.FINE, message, e);
                throw new DashboardException(message, e);
            }
        }
        finally {
            if (niagaraStation.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                niagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
        }
    }

    private BFoxSecurityDashboardChannel getFoxChannel() {
        return (BFoxSecurityDashboardChannel)this.getNiagaraStation().getClientConnection().getChannels().get("securityDashboard", BFoxSecurityDashboardChannel.TYPE);
    }

    private BDataChannel getDataChannel() {
        return (BDataChannel)this.getNiagaraStation().getClientConnection().getChannels().get("data", BDataChannel.TYPE);
    }

    private BSysChannel getSysChannel() {
        return (BSysChannel)this.getNiagaraStation().getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    private Version getRemoteVersion() {
        String remoteVersion = this.getNiagaraStation().getVersion();
        return remoteVersion.isEmpty() ? new Version("0") : new Version(remoteVersion);
    }

    private BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.importDescriptor.getDevice();
    }
}

