/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.json.JSONObject;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.nss.BSecurityService;
import com.tridium.nss.dashboard.BDashboardData;
import com.tridium.nss.dashboard.BSecurityDashboardDeviceExt;
import com.tridium.nss.dashboard.DashboardException;
import com.tridium.nss.dashboard.DashboardNotSupportedException;
import com.tridium.nss.dashboard.FoxRemoteDashboardDataRetriever;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BSecurityDashboardDataImport
extends BDescriptor
implements BIRestrictedComponent {
    public static final Type TYPE = Sys.loadType(BSecurityDashboardDataImport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"shield.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private static final Logger LOGGER = Logger.getLogger("securityDashboard");
    private static final String NOT_LICENSED = Lexicon.make(BSecurityDashboardDataImport.class).getText("securityDashboard.exception.systemNotLicensed");
    private final IRemoteDashboardDataRetriever dataRetriever = new FoxRemoteDashboardDataRetriever(this);
    final AtomicBoolean remoteStationSupported = new AtomicBoolean(true);
    private long failedAttempts;
    private long successfulExecutes;
    private long totalExecuteTime;
    private long minExecuteTime = Long.MAX_VALUE;
    private long maxExecuteTime;

    public Type getType() {
        return TYPE;
    }

    private JSONObject retrieveRemoteData(Context cx) {
        try {
            return this.dataRetriever.getRemoteDashboardData(cx);
        }
        catch (DashboardException e) {
            throw new CompletionException("Could not retrieve remote dashboard data", e);
        }
    }

    private void handleRetrievedData(JSONObject data, Throwable thrown) {
        try {
            if (thrown == null) {
                this.remoteStationSupported.set(true);
                this.getSecurityDashboardDeviceExt().setDashboardData(BDashboardData.make(data));
                this.executeOk();
            } else {
                if (thrown instanceof CompletionException) {
                    thrown = thrown.getCause();
                }
                if (thrown instanceof DashboardNotSupportedException) {
                    this.remoteStationSupported.set(false);
                } else {
                    LOGGER.log(Level.WARNING, "Failed to retrieve data for " + this.getSlotPathOrd(), thrown);
                    this.remoteStationSupported.set(true);
                }
                this.executeFail(thrown.getMessage());
            }
        }
        catch (Exception e) {
            this.executeFail(e);
        }
    }

    private BSecurityDashboardDeviceExt getSecurityDashboardDeviceExt() {
        return (BSecurityDashboardDeviceExt)this.getDeviceExt();
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        try {
            ((BNiagaraStation)this.getDevice()).getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        catch (Exception e) {
            if (this.getState() != BDescriptorState.idle) {
                this.executeFail(e);
            }
            throw e;
        }
        return null;
    }

    public void doExecute() {
        this.doExecute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(Context cx) {
        if (this.isUnoperational()) {
            this.setState(BDescriptorState.idle);
            return;
        }
        long startTicks = Clock.ticks();
        Throwable t = null;
        try {
            JSONObject result = null;
            long start = DiagnosticUtil.startIfLoggable((String)"securityDashboardDataImport_execute");
            try {
                this.executeInProgress();
                result = this.retrieveRemoteData(cx);
                this.getSecurityDashboardDeviceExt().refreshHttpsPort();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
            finally {
                if (start != 0L) {
                    DiagnosticUtil.complete((long)start, (String)"securityDashboardDataImport_execute", (Object)this.toPathString());
                }
                this.handleRetrievedData(result, t);
            }
            this.updateStatistics(startTicks, t != null);
        }
        catch (Exception e) {
            try {
                if (this.getState() != BDescriptorState.idle) {
                    this.executeFail(e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.updateStatistics(startTicks, t != null);
                throw throwable;
            }
        }
    }

    public boolean isUnoperational() {
        return super.isUnoperational() || BSecurityDashboardDeviceExt.isSystemSecurityDashboardUnoperational();
    }

    public void started() throws Exception {
        super.started();
        if (!BSecurityService.isSystemSecurityDashboardLicensed()) {
            this.executeFail(NOT_LICENSED);
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BSecurityDashboardDeviceExt.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(((Object)((Object)this)).getClass())) {
            if (slots.get() == this || this.getPropertyInParent() != null && !this.getPropertyInParent().isDynamic()) continue;
            throw new IllegalChildException("nss", "securityDashboardDeviceExt.duplicateDashboardExt", new Object[]{this.getType()});
        }
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"SecurityDashboardDataImport Statistics", 2);
            out.prop((Object)"Total failed execute attempts", (Object)String.valueOf(this.failedAttempts));
            out.prop((Object)"Total successful execute attempts", (Object)String.valueOf(this.successfulExecutes));
            out.prop((Object)"Total successful execute time", (Object)BRelTime.make((long)this.totalExecuteTime));
            long avgExecute = this.successfulExecutes > 0L ? this.totalExecuteTime / this.successfulExecutes : 0L;
            out.prop((Object)"Avg successful execute time", (Object)BRelTime.make((long)avgExecute));
            long min = this.minExecuteTime != Long.MAX_VALUE ? this.minExecuteTime : 0L;
            out.prop((Object)"Min successful execute time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max successful execute time", (Object)BRelTime.make((long)this.maxExecuteTime));
            out.endProps();
        }
        super.spy(out);
    }

    private void updateStatistics(long startTicks, boolean failedAttempt) {
        if (failedAttempt) {
            ++this.failedAttempts;
        } else {
            long duration = Clock.ticks() - startTicks;
            ++this.successfulExecutes;
            this.totalExecuteTime += duration;
            if (duration <= this.minExecuteTime) {
                this.minExecuteTime = duration;
            }
            if (duration >= this.maxExecuteTime) {
                this.maxExecuteTime = duration;
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

