/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="data", type="BPassword", flags=5, defaultValue="BPassword.DEFAULT")
public final class BDashboardData
extends BStruct {
    public static final Property data = BDashboardData.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BDashboardData.class);
    private String timestamp;
    static final BDashboardData DEFAULT = new BDashboardData();

    public BPassword getData() {
        return (BPassword)this.get(data);
    }

    public void setData(BPassword v) {
        this.set(data, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    static BDashboardData make(JSONObject dashboardDataJSON) {
        BDashboardData dashboardData = new BDashboardData();
        dashboardData.setFromJSON(dashboardDataJSON);
        return dashboardData;
    }

    public boolean isNull() {
        return this.getData().isDefault();
    }

    public void setFromJSON(JSONObject dashboardDataJSON) {
        String compressedDashboardData = BDashboardData.compressDataAndEncode(dashboardDataJSON.toString().getBytes(StandardCharsets.UTF_8));
        BPassword encryptedDashboardData = BPassword.make((String)compressedDashboardData, (String)BAes256PasswordEncoder.ENCODING_TYPE);
        this.setTimestampFromJSON(dashboardDataJSON);
        this.setData(encryptedDashboardData);
    }

    public JSONObject toJSON() {
        String compressedDashboardData = AccessController.doPrivileged(() -> this.getData().getValue());
        byte[] dashboardData = BDashboardData.decodeAndDecompress(compressedDashboardData);
        return new JSONObject(new String(dashboardData));
    }

    private void setTimestampFromJSON(JSONObject dashboardDataJson) {
        if (!dashboardDataJson.has("timestamp")) {
            throw new IllegalArgumentException("Station dashboard data must contain timestamp");
        }
        this.timestamp = JSONUtil.getString((JSONObject)dashboardDataJson, (String)"timestamp");
    }

    public String getTimestamp() {
        if (this.timestamp == null && !this.isNull()) {
            try {
                JSONObject jsonObject = this.toJSON();
                this.setTimestampFromJSON(jsonObject);
            }
            catch (Throwable e) {
                throw new IllegalStateException("DashboardData is not in proper format. setData() may have been called directly instead of setFromJSON");
            }
        }
        return this.timestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String compressDataAndEncode(byte[] uncompressedData) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(uncompressedData.length);){
            GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);
            Object object = null;
            try {
                zipStream.write(uncompressedData);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zipStream != null) {
                    if (object != null) {
                        try {
                            zipStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zipStream.close();
                    }
                }
            }
            byte[] compressedData = byteStream.toByteArray();
            object = Base64.getEncoder().encodeToString(compressedData);
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] decodeAndDecompress(String compressedData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isGzipStream(byte[] bytes) {
        int head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00;
        return 35615 == head;
    }
}

