/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.oracle.BOracleDatabase;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

public class BOracleConnectionPool
extends BAbstractConnectionPool {
    public static final Type TYPE = Sys.loadType(BOracleConnectionPool.class);
    private static final String CUSTOM_JDBC_URL = "customJdbcUrl";
    private BasicDataSource ds;

    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
            Logger.getLogger("rdbOracle").fine("oracle connection stats:  numActive: " + this.getNumActive() + ",  peakNumActive: " + this.getPeakNumActive() + ",  numIdle: " + this.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        String url;
        BOracleDatabase db = (BOracleDatabase)this.getParent();
        Property jdbcProp = db.getProperty(CUSTOM_JDBC_URL);
        if (jdbcProp == null) {
            String host = db.getHostname();
            int port = db.getPort();
            String protocol = db.getUseEncryptedConnection() ? "tcps" : "tcp";
            String serviceName = db.getServiceName();
            url = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + protocol + ")(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SERVICE_NAME=" + serviceName + ")))";
        } else {
            url = db.getString(jdbcProp);
            Logger.getLogger("rdb").fine("using custom jdbc connection: " + url);
        }
        if (this.ds == null) {
            Logger.getLogger("rdb").fine("initializing connection pool for " + url);
            this.ds = this.makeDataSource(url, userName, password);
        } else if (!(this.ds.getUrl().equals(url) && this.ds.getUsername().equals(userName) && this.ds.getPassword().equals(password))) {
            Logger.getLogger("rdb").fine("re-initializing connection pool for " + url);
            this.ds.close();
            this.ds = this.makeDataSource(url, userName, password);
        }
        if (Nre.bootEnv.isRemote()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws SQLException {
                        Connection connection = null;
                        Locale current = Locale.getDefault();
                        Locale.setDefault(Locale.US);
                        connection = BOracleConnectionPool.this.ds.getConnection();
                        Locale.setDefault(current);
                        return connection;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (SQLException)e.getException();
            }
        }
        return this.ds.getConnection();
    }

    private BasicDataSource makeDataSource(String url, String userName, String password) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setUrl(url);
        ds.setUsername(userName);
        ds.setPassword(password);
        ds.setMaxTotal(this.getMaxActive());
        ds.setMaxIdle(this.getMaxIdle());
        ds.setMaxWaitMillis((long)this.getMaxWait());
        ds.setAccessToUnderlyingConnectionAllowed(true);
        return ds;
    }
}

