/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.util.ThrowableUtil;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import javax.baja.web.BWebService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.owasp.encoder.Encode;

public class WebErrorHandler
extends ErrorPageErrorHandler {
    private static final LexiconModule LEX = LexiconModule.make((String)"web");

    public WebErrorHandler() {
        this.setShowServlet(false);
    }

    public boolean isShowStacks() {
        return BWebService.getMainService().getShowStackTrace();
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message, String contentType) throws IOException {
        Context cx;
        Optional webService;
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        boolean isSecurityException = false;
        boolean showStacks = this.isShowStacks();
        if (ThrowableUtil.toSecurity((Throwable)throwable).isPresent()) {
            isSecurityException = true;
        }
        if ((webService = Sys.findService((Type)BWebService.TYPE)).isPresent()) {
            showStacks = ((BWebService)webService.get()).getShowStackTrace();
        }
        if ((cx = (Context)request.getAttribute("niagara.context")) == null || cx.getUser() == null) {
            showStacks = false;
        }
        if (throwable != null && throwable.toString().equals(message) && !showStacks && !isSecurityException) {
            message = WebUtil.removeThrowablePrefixes((String)message, (Throwable)throwable, (Context)cx);
            request.setAttribute("javax.servlet.error.exception", null);
        } else if (isSecurityException) {
            message = LEX.getText("web.server.error", cx);
            request.setAttribute("javax.servlet.error.exception", null);
        }
        if (code >= 500 && code < 600) {
            code = 400;
        }
        super.generateAcceptableResponse(baseRequest, request, response, code, message, contentType);
    }

    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        Throwable th;
        Context cx = (Context)request.getAttribute("niagara.context");
        String uri = request.getRequestURI();
        writer.write("<h2>");
        String status = Integer.toString(code);
        writer.write(LEX.getHtmlSafeText("web.server.httpError", cx, new Object[]{status}));
        writer.write("</h2>\n");
        writer.write("<p>\n");
        writer.write(LEX.getHtmlSafeText("web.server.errorCaption", cx, new Object[]{uri}));
        writer.write("<pre>");
        writer.write(Encode.forHtml((String)message));
        writer.write("</pre>");
        writer.write("</p>");
        if (showStacks && (th = (Throwable)request.getAttribute("javax.servlet.error.exception")) != null) {
            writer.write("<h3>");
            writer.write(LEX.getHtmlSafeText("web.server.causedBy", cx));
            writer.write("</h3><pre>");
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
                pw.flush();
                this.write(writer, sw.getBuffer().toString());
            }
            writer.write("</pre>\n");
        }
    }
}

