/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.web.BHostnameRedirectSettings;
import com.tridium.web.CookieUtil;
import com.tridium.web.servlets.DefaultServlet;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class NiagaraDefaultHandler
extends AbstractHandler {
    private static final Logger LOGGER = Logger.getLogger("jetty");
    private DefaultServlet defaultServlet = new DefaultServlet();
    private String redirectHost = null;

    NiagaraDefaultHandler() {
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BHostnameRedirectSettings settings = service.getHostnameRedirectSettings();
            if (settings.getRedirectToHostname()) {
                String redirectHost = settings.getHostname();
                if (!redirectHost.isEmpty()) {
                    LOGGER.info(String.format("Configuring web server to redirect all traffic to <%s>.", redirectHost));
                    this.redirectHost = redirectHost;
                } else {
                    LOGGER.warning("Web Service configured to redirect to blank hostname. Ignoring redirect settings.");
                }
            }
        }
        catch (ServiceNotFoundException e) {
            LOGGER.warning("Web Service not found, skipping hostname redirection configuration.");
        }
        this.defaultServlet.init();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.defaultServlet.destroy();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        URL requestURL;
        String requestHost;
        if (this.redirectHost != null && !(requestHost = (requestURL = new URL(request.getRequestURL().toString())).getHost()).equalsIgnoreCase(this.redirectHost)) {
            Cookie noRedirectCookie = CookieUtil.getCookieFromName((HttpServletRequest)request, (String)"noRedirect");
            if (noRedirectCookie != null && "true".equals(noRedirectCookie.getValue())) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("noRedirect cookie found, skipping hostname redirect.");
                }
            } else if ("true".equals(request.getParameter("noRedirect"))) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("noRedirect parameter found, skipping hostname redirect.");
                }
                response.addCookie(CookieUtil.createCookie((String)"noRedirect", (String)"true", (int)-1));
            } else {
                String queryString;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("redirecting request to <%s>", this.redirectHost));
                }
                queryString = (queryString = request.getQueryString()) != null && !queryString.isEmpty() ? '?' + queryString : "";
                String file = requestURL.getFile() + queryString;
                URL redirectURL = new URL(requestURL.getProtocol(), this.redirectHost, requestURL.getPort(), file);
                response.setStatus(301);
                response.setHeader("Location", redirectURL.toString());
                baseRequest.setHandled(true);
                return;
            }
        }
        if (request.getMethod().equals("GET")) {
            if (target.equals("/")) {
                response.sendRedirect("/ord");
                baseRequest.setHandled(true);
            } else if (target.equals("/favicon.ico") || target.equals("/robots.txt")) {
                this.defaultServlet.service((ServletRequest)request, (ServletResponse)response);
                response.setStatus(200);
                baseRequest.setHandled(true);
            }
        }
    }
}

