/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.authn.LoginFailureCause;
import com.tridium.jetty.NiagaraSessionHandler;
import com.tridium.session.SessionManager;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.web.CookieUtil;
import com.tridium.web.authn.BHttpCallbackHandler;
import com.tridium.web.authn.FormsAndSchemesHandler;
import com.tridium.web.servlets.LoginSupport;
import com.tridium.web.servlets.WbServlet;
import com.tridium.web.servlets.WebStartServlet;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.file.types.application.BWasmFile;
import javax.baja.file.types.audio.BAudioFile;
import javax.baja.file.types.font.BFontFile;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.text.BCssFile;
import javax.baja.file.types.text.BHbsFile;
import javax.baja.file.types.text.BJavascriptFile;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.file.types.video.BVideoFile;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.authn.AuthMessage;
import javax.baja.web.authn.BHttpHeaderCallbackHandler;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public final class NiagaraAuthenticator
extends LoginAuthenticator {
    private static final String AUTH_METHOD = "NIAGARA_AUTH";
    private static final String __J_SECURITY_CHECK = "/j_security_check";
    protected static final String SESS_ATTR_CALLBACK = "callbackHandler";
    protected static final String SESS_ATTR_USER_IDENTITY = "userIdentity";
    protected static final String SESS_ATTR_AUTH_SCHEME = "authenticationScheme";
    protected static final String REQ_ATTR_CALLBACK = "com.tridium.jetty.callbackHandler";
    protected static final String REQ_ATTR_AUTH_SCHEME = "com.tridium.jetty.authenticationScheme";
    protected static final String REQ_ATTR_RESPONSE = "com.tridium.jetty.servletResponse";
    private static final String[] TERMINAL_BLACKLIST = new String[]{"/login", "/logout", "/prelogin"};
    private boolean webStartEnabled = false;
    private static final Logger log = Logger.getLogger("web");

    public String getAuthMethod() {
        return AUTH_METHOD;
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        UserIdentity.Scope scope;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)false);
        LoginSupport.handleUsernameCookie((HttpServletRequest)req, (HttpServletResponse)resp);
        String uri = req.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        if (req instanceof Request && (scope = ((Request)req).getUserIdentityScope()) instanceof ServletHolder && UnauthenticatedServlet.class.isAssignableFrom(((ServletHolder)scope).getHeldClass())) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        if (uri.toLowerCase().startsWith("/login-kerb")) {
            try {
                return this.authenticateKerberos(req, resp, uri);
            }
            catch (IOException e) {
                throw new ServerAuthException((Throwable)e);
            }
        }
        if (this.isWebStartDeferredRequest(uri) && !DeferredAuthentication.isDeferred((HttpServletResponse)resp)) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        try {
            Authentication authentication;
            if (this.isJSecurityCheck(uri)) {
                return this.jSecurityCheck(req, resp, uri);
            }
            Cookie superSessionCookie = CookieUtil.getCookieFromName((HttpServletRequest)req, (String)"super_session_id");
            if (superSessionCookie != null && SessionManager.isAuthenticated((String)superSessionCookie.getValue())) {
                session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
            }
            if (session != null && (authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity")) != null) {
                return authentication;
            }
            String header = req.getHeader("Authorization");
            if (header != null) {
                return this.authenticateHeader(req, resp, uri);
            }
            if (NiagaraAuthenticator.isValidRedirect(req)) {
                String fullUri = uri;
                if (req.getQueryString() != null) {
                    fullUri = fullUri + "?" + req.getQueryString();
                }
                Cookie cookie = CookieUtil.createCookie((String)"niagara_origin_uri", (String)fullUri, (int)-1, (boolean)true);
                cookie.setSecure(req.isSecure());
                resp.addCookie(cookie);
            }
            if (LoginSupport.getRequestedAttributeOrCookie((HttpServletRequest)req, (String)"loginFailureCause", (String)"niagara_failure_cause") != null) {
                resp.sendRedirect("/login?auth=fail");
            } else {
                resp.sendRedirect("/login");
            }
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authentication jSecurityCheck(HttpServletRequest req, HttpServletResponse resp, String uri) throws IOException {
        String requestedUsername = LoginSupport.getRequestedUsername((HttpServletRequest)req);
        if (requestedUsername == null) {
            requestedUsername = "";
        }
        List<BDigestAuthenticationScheme> schemes = null;
        BUserService userService = BUserService.getService();
        BAuthenticationService authnService = BAuthenticationService.getService();
        if (authnService.getStrictAuthentication()) {
            schemes = Collections.singletonList(LoginSupport.getSelectedAuthenticationScheme((HttpServletRequest)req));
        } else if (userService.getUser(requestedUsername) == null) {
            schemes = FormsAndSchemesHandler.getInstance().getSchemesFromRequest(req);
        } else {
            try {
                BAuthenticationScheme scheme = userService.getAuthenticationSchemeForUser(requestedUsername);
                if (scheme.getAgentOn(BILoginHTMLForm.class) != null) {
                    schemes = Collections.singletonList(userService.getAuthenticationSchemeForUser(requestedUsername));
                } else {
                    log.warning(String.format("User <%s> attempting web login with unsupported authentication scheme <%s>", requestedUsername, scheme.getName()));
                }
            }
            catch (Exception scheme) {
                // empty catch block
            }
        }
        if (schemes == null || schemes.isEmpty()) {
            schemes = Collections.singletonList(new BDigestAuthenticationScheme());
        }
        int i = 0;
        while (true) {
            NiagaraWebSession session;
            if (i >= schemes.size()) {
                resp.sendRedirect("/login");
                return Authentication.SEND_CONTINUE;
            }
            BAuthenticationScheme authnScheme = (BAuthenticationScheme)schemes.get(i);
            String originUri = LoginSupport.getOriginUri((HttpServletRequest)req);
            if (originUri == null) {
                originUri = "/ord";
            }
            BWebCallbackHandler handler = (session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)false)) == null ? null : (BWebCallbackHandler)session.getAttribute(SESS_ATTR_CALLBACK);
            Cookie ssoSchemeNameCookie = CookieUtil.getCookieFromName((HttpServletRequest)req, (String)"niagara_current_sso_scheme");
            BSSOAuthenticationScheme ssoScheme = null;
            if (ssoSchemeNameCookie != null) {
                ssoScheme = BAuthenticationService.getService().getSSOAuthenticationScheme(ssoSchemeNameCookie.getValue());
            }
            if (ssoScheme != null) {
                handler = (BWebCallbackHandler)ssoScheme.getAgentOn(BWebCallbackHandler.class);
                authnScheme = ssoScheme;
            } else if (handler == null) {
                session = NiagaraAuthenticator.recreateSession(req, originUri);
                handler = (BWebCallbackHandler)authnScheme.getAgentOn(BWebCallbackHandler.class);
            } else if (!handler.getType().equals(((BWebCallbackHandler)authnScheme.getAgentOn(BWebCallbackHandler.class)).getType())) {
                session = NiagaraAuthenticator.recreateSession(req, originUri);
                handler = (BWebCallbackHandler)authnScheme.getAgentOn(BWebCallbackHandler.class);
            }
            req.setAttribute(REQ_ATTR_AUTH_SCHEME, (Object)authnScheme);
            req.setAttribute(REQ_ATTR_CALLBACK, (Object)handler);
            req.setAttribute(REQ_ATTR_RESPONSE, (Object)resp);
            int responseCode = handler.handleRequest(req, resp);
            if (responseCode == 2) {
                resp.sendRedirect("/login");
                return Authentication.SEND_CONTINUE;
            }
            if (responseCode == 0) {
                UserIdentity user;
                if (handler.getUsername() == null) {
                    FormsAndSchemesHandler.getInstance().incrementFormAndSchemeCookies(req, resp);
                    resp.sendRedirect("/login");
                    return Authentication.SEND_CONTINUE;
                }
                if (!(requestedUsername.equals(handler.getUsername()) || handler.getUsername().isEmpty() || authnScheme instanceof BSSOAuthenticationScheme)) {
                    BWebService webService = BWebService.getMainService();
                    if (session == null && !webService.getRememberUserIdCookie()) {
                        session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                    }
                    if (session != null) {
                        session.setAttribute("username", (Object)handler.getUsername());
                    }
                    if (webService.getRememberUserIdCookie()) {
                        String newUserCookieName = "niagara_userid";
                        Cookie cookie = CookieUtil.createCookie((String)newUserCookieName, (String)handler.getUsername(), (int)CookieUtil.COOKIE_AGE);
                        cookie.setSecure(req.isSecure());
                        resp.addCookie(cookie);
                    }
                }
                requestedUsername = handler.getUsername();
                UserIdentity userIdentity = user = session == null ? null : (UserIdentity)session.getAttribute(SESS_ATTR_USER_IDENTITY);
                if (user == null) {
                    user = this.login(requestedUsername, session, (ServletRequest)req);
                }
                if (user != null) {
                    Boolean reset;
                    Boolean bl = reset = session == null ? null : (Boolean)session.getAttribute("forceReset");
                    if (reset != null && reset.booleanValue()) {
                        if (req.getParameter("resetToken") == null) {
                            session = NiagaraAuthenticator.recreateSession(req, originUri);
                            session.setAttribute("forceReset", (Object)true);
                            session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
                            resp.sendRedirect("/login");
                            return Authentication.SEND_CONTINUE;
                        }
                        String newPassword = new String(Base64.getDecoder().decode(req.getParameter("resetToken")));
                        BUser requestedUser = userService.getUser(requestedUsername);
                        try {
                            this.resetPassword(requestedUser, newPassword);
                            session.setAttribute("forceReset", (Object)false);
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Unable to Reset Password", e);
                            String errMsg = e.getMessage();
                            if (errMsg == null) {
                                errMsg = "Security Exception";
                            }
                            session = NiagaraAuthenticator.recreateSession(req, originUri);
                            session.setAttribute("forceReset", (Object)true);
                            session.setAttribute("resetError", (Object)errMsg);
                            session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
                            resp.sendRedirect("/login");
                            return Authentication.SEND_CONTINUE;
                        }
                    } else if (this.handlePasswordReset(req, resp, userService.getUser(requestedUsername))) {
                        session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                        LoginFailureCause loginFailureCause = (LoginFailureCause)session.getAttribute("loginFailureCause");
                        if (loginFailureCause != LoginFailureCause.ILLEGAL_NETWORK_USER_RESET && loginFailureCause != LoginFailureCause.INSECURE_PASSWORD_RESET) {
                            session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
                            session.setAttribute(SESS_ATTR_USER_IDENTITY, (Object)user);
                            return Authentication.SEND_CONTINUE;
                        }
                        return Authentication.SEND_FAILURE;
                    }
                    this.commonCleanupOnAuthentication(req, resp);
                    resp.sendRedirect(originUri);
                    FormsAndSchemesHandler.getInstance().clearFormAndSchemeCookies(resp);
                    if (session != null) {
                        session.removeAttribute(SESS_ATTR_USER_IDENTITY);
                        session.removeAttribute(SESS_ATTR_CALLBACK);
                    }
                    return new NiagaraAuthentication(authnScheme.getSchemeName(), user);
                }
                if (i == schemes.size() - 1) {
                    session = NiagaraAuthenticator.recreateSession(req, originUri);
                    FormsAndSchemesHandler.getInstance().incrementFormAndSchemeCookies(req, resp);
                    resp.sendRedirect("/login?auth=fail");
                    return Authentication.SEND_FAILURE;
                }
            } else {
                if (responseCode == 1) {
                    session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                    session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
                    return Authentication.SEND_CONTINUE;
                }
                if (responseCode == 3) {
                    FormsAndSchemesHandler.getInstance().incrementFormAndSchemeCookies(req, resp);
                    NiagaraAuthenticator.recreateSession(req, originUri);
                    resp.sendRedirect("/login?auth=fail");
                    return Authentication.SEND_FAILURE;
                }
            }
            ++i;
        }
    }

    private Authentication authenticateKerberos(HttpServletRequest req, HttpServletResponse resp, String uri) throws IOException {
        String originUri;
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)false);
        List schemes = FormsAndSchemesHandler.getInstance().getSchemesFromRequest(req);
        if (schemes == null) {
            BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
            schemes = authnService.getRemoteSchemes();
        }
        if ((originUri = LoginSupport.getOriginUri((HttpServletRequest)req)) == null) {
            originUri = "/ord";
        }
        for (int i = 0; i < schemes.size(); ++i) {
            int responseCode;
            BWebCallbackHandler handler;
            BAuthenticationScheme scheme = (BAuthenticationScheme)schemes.get(i);
            if (!scheme.getSchemeName().equals("n4Kerberos")) {
                if (i != schemes.size() - 1) continue;
                NiagaraAuthenticator.recreateSession(req, originUri);
                resp.sendRedirect("/prelogin?auth=fail");
                return Authentication.SEND_FAILURE;
            }
            BWebCallbackHandler bWebCallbackHandler = handler = session == null ? null : (BWebCallbackHandler)session.getAttribute(SESS_ATTR_CALLBACK);
            if (handler == null) {
                handler = (BWebCallbackHandler)scheme.getAgentOn(BWebCallbackHandler.class);
                session = NiagaraAuthenticator.recreateSession(req, originUri);
            }
            if (!handler.getType().equals(((BWebCallbackHandler)scheme.getAgentOn(BWebCallbackHandler.class)).getType())) {
                session = NiagaraAuthenticator.recreateSession(req, originUri);
                handler = (BWebCallbackHandler)scheme.getAgentOn(BWebCallbackHandler.class);
            }
            if ((responseCode = handler.handleRequest(req, resp)) == 0) {
                schemes.remove(0);
                req.setAttribute(REQ_ATTR_AUTH_SCHEME, (Object)scheme);
                req.setAttribute(REQ_ATTR_CALLBACK, (Object)handler);
                req.setAttribute(REQ_ATTR_RESPONSE, (Object)resp);
                UserIdentity user = this.login("", session, (ServletRequest)req);
                if (user != null) {
                    if (session == null) {
                        session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                    }
                    this.commonCleanupOnAuthentication(req, resp);
                    resp.sendRedirect(originUri);
                    session.removeAttribute(SESS_ATTR_CALLBACK);
                    FormsAndSchemesHandler.getInstance().clearFormAndSchemeCookies(resp);
                    return new NiagaraAuthentication(scheme.getSchemeName(), user);
                }
                if (i != schemes.size() - 1) continue;
                NiagaraAuthenticator.recreateSession(req, originUri);
                FormsAndSchemesHandler.getInstance().incrementFormAndSchemeCookies(req, resp);
                resp.sendRedirect("/prelogin?auth=fail");
                return Authentication.SEND_FAILURE;
            }
            if (responseCode == 1) {
                if (session == null) {
                    session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                }
                session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
                return Authentication.SEND_CONTINUE;
            }
            if (responseCode != 3) continue;
            NiagaraAuthenticator.recreateSession(req, originUri);
            FormsAndSchemesHandler.getInstance().incrementFormAndSchemeCookies(req, resp);
            resp.sendRedirect("/prelogin?auth=fail");
            return Authentication.SEND_FAILURE;
        }
        resp.sendRedirect("/login");
        return Authentication.SEND_CONTINUE;
    }

    private Authentication authenticateHeader(HttpServletRequest req, HttpServletResponse resp, String uri) throws IOException {
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)false);
        boolean authHello = false;
        String header = req.getHeader("Authorization");
        AuthMessage message = null;
        try {
            message = AuthMessage.decodeFromString((String)header);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BAuthenticationScheme authnScheme = null;
        if (session != null) {
            authnScheme = (BAuthenticationScheme)session.getAttribute(SESS_ATTR_AUTH_SCHEME);
        }
        if (authnScheme == null) {
            BUserService userService;
            String requestedUsername;
            block31: {
                requestedUsername = null;
                if (message != null && message.getScheme().equalsIgnoreCase("HELLO")) {
                    authHello = true;
                    try {
                        String base64Username = message.getParameter("username");
                        if (base64Username != null) {
                            requestedUsername = new String(Base64.getUrlDecoder().decode(base64Username.getBytes()), StandardCharsets.UTF_8);
                        }
                    }
                    catch (IllegalArgumentException base64Username) {}
                } else {
                    int spaceIndex = header.indexOf(32);
                    if (spaceIndex > -1) {
                        String scheme = header.substring(0, spaceIndex);
                        if ("Basic".equalsIgnoreCase(scheme)) {
                            try {
                                String creds = new String(Base64.getDecoder().decode(header.substring(spaceIndex + 1)));
                                int colIndex = creds.indexOf(58);
                                if (colIndex > -1) {
                                    requestedUsername = creds.substring(0, colIndex);
                                    break block31;
                                }
                                log.warning("Invalid authorization header, colon delimiter not found.");
                            }
                            catch (IllegalArgumentException ignored) {
                                log.warning("Invalid authorization header, not valid base64.");
                            }
                        } else {
                            log.warning("Invalid authorization header, scheme not supported: " + scheme);
                        }
                    } else {
                        log.warning("Invalid authorization header, unable to parse scheme.");
                    }
                }
            }
            if (requestedUsername != null && (authnScheme = (userService = (BUserService)Sys.getService((Type)BUserService.TYPE)).getAuthenticationSchemeForUser(requestedUsername)) == null && authHello) {
                authnScheme = new BDigestAuthenticationScheme();
            }
        }
        BHttpCallbackHandler handler = null;
        if (session != null) {
            handler = (BHttpCallbackHandler)session.getAttribute(SESS_ATTR_CALLBACK);
        }
        if (handler == null && authnScheme != null) {
            handler = authHello ? (BHttpCallbackHandler)authnScheme.getAgentOn(BHttpHeaderCallbackHandler.class) : (BHttpCallbackHandler)authnScheme.getAgentOn(BWebCallbackHandler.class);
        }
        if (handler == null) {
            resp.sendError(401, "Authentication failed.");
            return Authentication.SEND_FAILURE;
        }
        int responseCode = handler.handleRequest(req, resp);
        if (responseCode == 0) {
            session = NiagaraAuthenticator.recreateSession(req, uri);
            req.setAttribute(REQ_ATTR_AUTH_SCHEME, (Object)authnScheme);
            req.setAttribute(REQ_ATTR_CALLBACK, (Object)handler);
            req.setAttribute(REQ_ATTR_RESPONSE, (Object)resp);
            UserIdentity user = this.login(handler.getUsername(), session, (ServletRequest)req);
            if (session != null) {
                session.removeAttribute(SESS_ATTR_CALLBACK);
                session.removeAttribute(SESS_ATTR_AUTH_SCHEME);
            }
            if (user != null) {
                if (session == null) {
                    session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
                }
                if (handler instanceof BHttpHeaderCallbackHandler) {
                    Map authInfoParameters = ((BHttpHeaderCallbackHandler)handler).getAuthInfoParameters();
                    StringJoiner joiner = new StringJoiner(", ");
                    joiner.add("authToken=" + session.getId());
                    for (Map.Entry entry : authInfoParameters.entrySet()) {
                        joiner.add((String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    resp.setHeader("Authentication-Info", joiner.toString());
                }
                this.commonCleanupOnAuthentication(req, resp);
                return new NiagaraUserAuthentication(authnScheme.getSchemeName(), user);
            }
            int code = handler instanceof BHttpHeaderCallbackHandler ? 403 : 401;
            resp.sendError(code, "Authentication failed.");
            return Authentication.SEND_FAILURE;
        }
        if (responseCode == 1) {
            String respHeader;
            resp.setStatus(401);
            if (session == null) {
                session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
            }
            if (handler instanceof BHttpHeaderCallbackHandler && (respHeader = resp.getHeader("WWW-Authenticate")) != null) {
                try {
                    AuthMessage respMessage = AuthMessage.decodeFromString((String)respHeader);
                    respMessage.setParameter("handshakeToken", session.getId());
                    resp.setHeader("WWW-Authenticate", respMessage.encodeToString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            session.setAttribute(SESS_ATTR_AUTH_SCHEME, (Object)authnScheme);
            session.setAttribute(SESS_ATTR_CALLBACK, (Object)handler);
            return Authentication.SEND_CONTINUE;
        }
        int code = handler instanceof BHttpHeaderCallbackHandler ? 403 : 401;
        resp.sendError(code, "Authentication failed.");
        return Authentication.SEND_FAILURE;
    }

    private void updateToAuthenticatedMaxInactiveInterval(HttpServletRequest req) {
        Session jettySession;
        SessionHandler sessionHandler;
        HttpSession httpSession = req.getSession(false);
        if (httpSession instanceof Session && (sessionHandler = (jettySession = (Session)httpSession).getSessionHandler()) instanceof NiagaraSessionHandler) {
            ((NiagaraSessionHandler)sessionHandler).updateToAuthenticatedMaxInactiveInterval(jettySession);
        }
    }

    private boolean handlePasswordReset(HttpServletRequest req, HttpServletResponse resp, BUser user) throws IOException {
        boolean networkUser;
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)req, (boolean)true);
        BAuthenticationScheme scheme = user.getAuthenticationScheme();
        BAbstractAuthenticator authenticator = user.getAuthenticator();
        BUserPasswordConfiguration userPassConfig = null;
        BGlobalPasswordConfiguration[] globalPassConfig = (BGlobalPasswordConfiguration[])scheme.getChildren(BGlobalPasswordConfiguration.class);
        if (authenticator instanceof BPasswordAuthenticator) {
            userPassConfig = ((BPasswordAuthenticator)authenticator).getPasswordConfig();
        }
        boolean redirect = false;
        boolean forceReset = false;
        boolean confirmForceReset = false;
        boolean expReset = false;
        TypeInfo USER_SYNC_EXT_TYPE = BTypeSpec.make((String)"niagaraDriver", (String)"UserSyncExt").getTypeInfo();
        Property syncExtProp = user.getProperty("syncExt");
        boolean bl = networkUser = user.getNetworkUser() && Flags.isReadonly((BComplex)user.getParent(), (Slot)user.getPropertyInParent()) && syncExtProp != null && USER_SYNC_EXT_TYPE != null && syncExtProp.getType().is(USER_SYNC_EXT_TYPE);
        if (userPassConfig != null) {
            if (globalPassConfig.length > 0) {
                BAbsTime expTime = userPassConfig.getExpiration();
                BRelTime warningPeriod = globalPassConfig[0].getWarningPeriod();
                if (!expTime.isNull() && expTime.isBefore(BAbsTime.now())) {
                    forceReset = true;
                } else if (!expTime.isNull() && expTime.subtract(warningPeriod).isBefore(BAbsTime.now())) {
                    session.setAttribute("passwordExpires", (Object)expTime.getMillis());
                    session.setAttribute("networkUser", (Object)networkUser);
                    redirect = true;
                    if (req.getParameter("yes-reset") != null) {
                        expReset = true;
                        session.removeAttribute("passwordExpires");
                        session.removeAttribute("networkUser");
                    } else if (req.getParameter("no-reset") != null) {
                        session.removeAttribute("passwordExpires");
                        session.removeAttribute("networkUser");
                        redirect = false;
                    }
                }
            }
            boolean bl2 = forceReset = userPassConfig.getForceResetAtNextLogin() || expReset || forceReset;
            if (forceReset) {
                String originUri = (String)session.getAttribute("originURI");
                session = NiagaraAuthenticator.recreateSession(req, originUri);
                if (!req.isSecure() && BWebService.getMainService().getRequireHttpsForPasswords()) {
                    resp.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.INSECURE_PASSWORD_RESET.name(), (int)-1));
                } else if (networkUser) {
                    resp.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.ILLEGAL_NETWORK_USER_RESET.name(), (int)-1));
                } else {
                    confirmForceReset = true;
                    session.setAttribute("forceReset", (Object)true);
                }
                redirect = true;
            }
        }
        if (forceReset && !confirmForceReset) {
            resp.sendRedirect("/login?auth=fail");
        } else if (redirect) {
            resp.sendRedirect("/login");
        }
        return redirect;
    }

    public void resetPassword(BUser user, String password) throws Exception {
        BAbstractAuthenticator auth = user.getAuthenticator();
        if (((BPasswordCache)user.getAuthenticator()).validate(password)) {
            throw new LocalizableException(Lexicon.make((String)"baja"), "user.strongPassword.alreadyUsed");
        }
        auth.set(BPasswordAuthenticator.password, (BValue)BPassword.make((String)password), Context.forceValidate);
        if (auth instanceof BPasswordAuthenticator) {
            BUserPasswordConfiguration userConfig = ((BPasswordAuthenticator)user.getAuthenticator()).getPasswordConfig();
            userConfig.setForceResetAtNextLogin(false);
        }
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return false;
    }

    public UserIdentity login(String username, Object session, ServletRequest request) {
        return super.login(username, session, request);
    }

    private boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    private static NiagaraWebSession recreateSession(HttpServletRequest req, String originUri) {
        return LoginSupport.recreateSession((HttpServletRequest)req, null, (String)originUri);
    }

    private boolean isWebStartDeferredRequest(String uri) {
        if (this.webStartEnabled) {
            if (uri.startsWith("/webstart/") && WebStartServlet.matchDeferredAuthRequest((String)uri)) {
                return true;
            }
            if (uri.startsWith("/wb/wbapplet") ? WebStartServlet.getAppletHref().equals(uri) : !WbServlet.disableJxBrowser && uri.startsWith("/wb/bin/ext/jxbrowser") && WebStartServlet.isJxBrowserJarRequest((String)uri)) {
                return true;
            }
        }
        return false;
    }

    public void setWebStartEnabled(boolean enabled) {
        this.webStartEnabled = enabled;
    }

    private static boolean isValidRedirect(HttpServletRequest req) {
        if (!req.getMethod().equals("GET")) {
            return false;
        }
        String servletPath = req.getServletPath();
        for (String s : TERMINAL_BLACKLIST) {
            if (!servletPath.equals(s)) continue;
            return false;
        }
        String uri = req.getRequestURI();
        if (WebStartServlet.matchDeferredAuthRequest((String)uri)) {
            return false;
        }
        String queryString = req.getQueryString();
        return NiagaraAuthenticator.isValidRedirectFile(uri) && (Objects.isNull(queryString) || NiagaraAuthenticator.isValidRedirectFile(req.getQueryString()));
    }

    private static boolean isValidRedirectFile(String file) {
        String ext = FileUtil.getExtension((String)file);
        if (ext == null) {
            return true;
        }
        TypeInfo info = Sys.getRegistry().getFileTypeForExtension(ext);
        if (info == null) {
            return true;
        }
        return !info.is(BImageFile.TYPE.getTypeInfo()) && !info.is(BAudioFile.TYPE.getTypeInfo()) && !info.is(BVideoFile.TYPE.getTypeInfo()) && !info.is(BCssFile.TYPE.getTypeInfo()) && !info.is(BJavascriptFile.TYPE.getTypeInfo()) && !info.is(BFontFile.TYPE.getTypeInfo()) && !info.is(BWasmFile.TYPE.getTypeInfo()) && !info.is(BHbsFile.TYPE.getTypeInfo()) && !info.is(BJsonFile.TYPE.getTypeInfo());
    }

    private void commonCleanupOnAuthentication(HttpServletRequest request, HttpServletResponse response) {
        this.updateToAuthenticatedMaxInactiveInterval(request);
        response.addCookie(CookieUtil.createCookie((String)"niagara_essential_session_support", (String)"", (int)0));
    }

    public static final class NiagaraUserAuthentication
    extends UserAuthentication
    implements Authentication.User {
        public NiagaraUserAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "Niagara" + super.toString();
        }
    }

    public static final class NiagaraAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public NiagaraAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "Niagara" + super.toString();
        }
    }
}

