/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table.view;

import java.util.ArrayList;
import javax.baja.hx.HxOp;
import javax.baja.hx.table.view.CompTableViewCol;
import javax.baja.hx.table.view.TableViewModel;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public class CompTableViewModel
extends TableViewModel {
    protected BComponent[] rows;
    protected CompTableViewCol[] cols;
    protected CompTableViewCol[] editable;
    protected CompTableViewCol[] visible;

    public CompTableViewModel(HxOp op) throws Exception {
        CompTableViewCol col;
        int i;
        this.cols = this.makeColumns(op);
        this.rows = this.makeRows(op);
        ArrayList<CompTableViewCol> list = new ArrayList<CompTableViewCol>();
        for (i = 0; i < this.cols.length; ++i) {
            col = this.cols[i];
            if (col.isUnseen()) continue;
            list.add(col);
        }
        this.visible = list.toArray(new CompTableViewCol[list.size()]);
        list.clear();
        for (i = 0; i < this.cols.length; ++i) {
            col = this.cols[i];
            if (!col.isEditable()) continue;
            list.add(col);
        }
        this.editable = list.toArray(new CompTableViewCol[list.size()]);
    }

    public Type[] getNewTypes() {
        return null;
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BComponent.TYPE};
    }

    public boolean accept(BComponent component) {
        return true;
    }

    public BComponent newInstance(Type type) throws Exception {
        return (BComponent)type.getInstance();
    }

    public CompTableViewCol[] getEditableColumns() {
        return this.editable;
    }

    public CompTableViewCol[] makeColumns(HxOp op) {
        return new CompTableViewCol[]{new CompTableViewCol.Name(), new CompTableViewCol.Type()};
    }

    public BComponent[] makeRows(HxOp op) throws Exception {
        BComponent[] kids = op.get().asComponent().getChildComponents();
        Type[] types = this.getIncludeTypes();
        ArrayList<BComponent> list = new ArrayList<BComponent>();
        for (int i = 0; i < kids.length; ++i) {
            BComponent c = kids[i];
            for (int j = 0; j < types.length; ++j) {
                if (!c.getType().is(types[j]) || !this.accept(c)) continue;
                try {
                    op.getUser().checkRead((BComponent)op.get(), (Slot)c.getPropertyInParent());
                    list.add(kids[i]);
                    continue;
                }
                catch (PermissionException permissionException) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new BComponent[list.size()]);
    }

    @Override
    public int getColumnCount() {
        return this.visible.length;
    }

    @Override
    public String getColumnName(int col, HxOp op) {
        return this.visible[col].getDisplayName((Context)op);
    }

    @Override
    public int getRowCount(int group) {
        return this.rows.length;
    }

    @Override
    public Object getValueAt(int group, int row, int col, HxOp op) {
        BComponent r = this.rows[row];
        Object value = this.visible[col].get(r);
        return this.visible[col].toDisplayString(r, value, (Context)op);
    }

    @Override
    public Object getRowObject(int group, int row, HxOp op) {
        return this.rows[row];
    }
}

