/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.px.binding;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.BIAgent;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.PropertiesCollection;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.enums.BDegradeBehavior;
import javax.baja.ui.event.BInputEvent;

public abstract class BHxPxBinding
extends BSingleton
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BHxPxBinding.class);
    private int eventCounter = 0;
    protected HashMap<String, Event> events = new HashMap();
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static AgentFilter agentFilter = AgentFilter.is((Type)TYPE);

    public Type getType() {
        return TYPE;
    }

    protected BHxPxBinding() {
    }

    public static BHxPxBinding makeFor(BBinding obj) {
        return BHxPxBinding.makeFor(obj, null);
    }

    public static BHxPxBinding makeFor(BBinding obj, Context cx) {
        try {
            return (BHxPxBinding)obj.getAgents().filter(BHxFieldEditor.getAgentFilter(agentFilter, cx)).getDefault().getInstance();
        }
        catch (NoSuchAgentException e) {
            throw new NoSuchAgentException("No HxPxBinding for " + obj.getType());
        }
    }

    public void write(HxOp op) throws Exception {
    }

    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        BBinding binding = (BBinding)op.get();
        HxOp baseOp = (HxOp)op.getBase().getBase();
        if (!binding.getWidget().getVisible() || binding.getDegradeBehavior() == BDegradeBehavior.hide && !binding.getOrd().isNull() && !binding.isBound()) {
            PropertiesCollection.Styles style = new PropertiesCollection.Styles();
            style.add("visibility", "hidden");
            style.write(baseOp);
        } else {
            PropertiesCollection.Styles style = new PropertiesCollection.Styles();
            style.add("visibility", "inherit");
            style.write(baseOp);
        }
        if (!binding.getWidget().getEnabled() || binding.getDegradeBehavior() == BDegradeBehavior.disable && !binding.getOrd().isNull() && !binding.isBound()) {
            binding.getWidget().setEnabled(false);
        } else {
            binding.getWidget().setEnabled(true);
        }
    }

    public void handle(BInputEvent event, HxOp op) throws Exception {
    }

    public boolean process(HxOp op) throws Exception {
        String path;
        String contentType = op.getRequest().getContentType();
        if (contentType.startsWith("application/x-niagara-hx-event") && (path = op.getRequest().getHeader("x-niagara-hx-path")).equals(op.getPath())) {
            String eventId = op.getRequest().getHeader("x-niagara-hx-eventId");
            Event event = null;
            if (event == null) {
                event = this.events.get(eventId);
            }
            if (event != null) {
                op.decodeFormValues();
                event.handle(op);
                byte[] bytes = op.getContent().toString().getBytes(UTF_8);
                op.getResponse().setContentLength(bytes.length);
                op.getResponse().getOutputStream().write(bytes, 0, bytes.length);
                return true;
            }
        }
        return false;
    }

    public void save(BObject value, HxOp op) throws Exception {
    }

    public String validateBinding(BBinding binding, Context cx) {
        return null;
    }

    public void registerEvent(Event event) {
        this.registerEvent(event, "event" + this.eventCounter++);
    }

    private void registerEvent(Event event, String id) {
        event.setId(id);
        this.events.put(event.getId(), event);
    }
}

