/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BajaRuntimeException;

public abstract class PropertiesCollection {
    LinkedHashMap<String, String> properties = new LinkedHashMap();
    HashSet<String> unsafeProperties = new LinkedHashSet<String>();
    boolean snoop = true;

    public void add(String name, String value) {
        if (!value.equals(this.properties.get(name))) {
            this.properties.put(name, value);
        }
    }

    public void addUnsafe(String name, String value) {
        if (!value.equals(this.properties.get(name))) {
            this.properties.put(name, value);
        }
        this.unsafeProperties.add(name);
    }

    public void setSnoopEnabled(boolean snoop) {
        this.snoop = snoop;
    }

    public void add(PropertiesCollection add) {
        Object[] keys = add.properties.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.add((String)keys[i], add.properties.get(keys[i]));
        }
    }

    public String get(String name) {
        return this.properties.get(name);
    }

    public void append(String name, String value) {
        if (this.properties.containsKey(name)) {
            this.properties.put(name, this.properties.get(name) + " " + value);
        } else {
            this.add(name, value);
        }
    }

    public void appendUnsafe(String name, String value) {
        if (this.properties.containsKey(name)) {
            this.properties.put(name, this.properties.get(name) + " " + value);
            this.unsafeProperties.add(name);
        } else {
            this.addUnsafe(name, value);
        }
    }

    public void write(HxOp op) throws IOException {
        this.write(op.getPath(), op);
    }

    public void write(String path, HxOp op) throws IOException {
        if (this.properties.isEmpty()) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        if (!this.snoop) {
            out.w((Object)"/* @noSnoop */");
        }
        out.w((Object)"px.setProperties('").w((Object)path).w((Object)"',").w((Object)this.doWrite()).w((Object)");\n");
    }

    protected String doWrite() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        Object[] keys = this.properties.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            try {
                if (i > 0) {
                    out.append(",");
                }
                String key = (String)keys[i];
                String value = this.properties.get(key);
                boolean decode = false;
                if (this.unsafeProperties.contains(key)) {
                    value = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
                    decode = true;
                } else {
                    value = HxUtil.encodeText(value);
                }
                out.append("{").append("\"key\":\"").append(key).append("\",").append("\"value\":\"").append(value).append("\",").append("\"decode\":").append(decode).append("}");
                continue;
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Unable to encode HxPx property value.", (Throwable)e);
            }
        }
        out.append("]");
        return out.toString();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        Object[] keys = this.properties.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            try {
                String key = (String)keys[i];
                out.append(key).append(": ").append(HxUtil.encodeText(this.properties.get(key))).append(";");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out.toString();
    }

    public static class Styles
    extends PropertiesCollection {
        @Override
        public void write(String path, HxOp op) throws IOException {
            if (this.properties.isEmpty()) {
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            if (!this.snoop) {
                out.w((Object)"/* @noSnoop */");
            }
            out.w((Object)"px.setStyle('").w((Object)path).w((Object)"',").w((Object)this.doWrite()).w((Object)");\n");
        }
    }

    public static class Events
    extends PropertiesCollection {
        @Override
        public void write(String path, HxOp op) throws IOException {
            if (this.properties.isEmpty()) {
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            if (!this.snoop) {
                out.w((Object)"/* @noSnoop */");
            }
            out.w((Object)"px.setEvents('").w((Object)path).w((Object)"',").w((Object)this.doWrite()).w((Object)");\n");
        }
    }

    public static class Properties
    extends PropertiesCollection {
    }
}

