/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.util;

import java.util.List;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;

public final class OrdUtil {
    private OrdUtil() {
    }

    public static ViewQuery getViewQuery(BOrd ord) {
        if (ord.isNull()) {
            return null;
        }
        return OrdUtil.getViewQuery(OrdUtil.getNormalizedParse(ord));
    }

    public static BOrd getOrdWithoutViewQuery(BOrd ord) {
        if (ord.isNull()) {
            return BOrd.NULL;
        }
        return OrdUtil.getOrdWithoutViewQuery(OrdUtil.getNormalizedParse(ord));
    }

    public static BOrd getOrdWithoutViewQueryParameters(OrdTarget target, List<String> removeKeys, boolean removeViewId) {
        return OrdUtil.getOrdWithoutViewQueryParameters(target.getOrdWithoutViewQuery(), target.getViewQuery(), removeKeys, removeViewId);
    }

    public static BOrd getOrdWithoutViewQueryParameters(BOrd ord, List<String> removeKeys, boolean removeViewId) {
        if (ord.isNull()) {
            return BOrd.NULL;
        }
        OrdQuery[] queries = OrdUtil.getNormalizedParse(ord);
        return OrdUtil.getOrdWithoutViewQueryParameters(OrdUtil.getOrdWithoutViewQuery(queries), OrdUtil.getViewQuery(queries), removeKeys, removeViewId);
    }

    private static BOrd getOrdWithoutViewQueryParameters(BOrd ordWithoutViewQuery, ViewQuery viewQuery, List<String> removeKeys, boolean removeViewId) {
        String body;
        if (viewQuery == null) {
            return ordWithoutViewQuery;
        }
        StringBuilder b = new StringBuilder();
        viewQuery.getParameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (removeKeys.contains(key)) {
                return;
            }
            if (b.length() == 0) {
                b.append('?');
            } else {
                b.append(';');
            }
            b.append(key).append('=').append(value);
        });
        String viewId = viewQuery.getViewId();
        if (viewId == null || removeViewId) {
            viewId = "";
        }
        if ((body = viewId + b.toString()).isEmpty()) {
            return ordWithoutViewQuery;
        }
        ViewQuery newViewQuery = new ViewQuery(body);
        return BOrd.make((BOrd)ordWithoutViewQuery, (OrdQuery)newViewQuery);
    }

    private static OrdQuery[] getNormalizedParse(BOrd ord) {
        return ord.normalize().parse();
    }

    private static ViewQuery getViewQuery(OrdQuery[] queries) {
        int n = queries.length - 1;
        if (n >= 0 && queries[n] instanceof ViewQuery) {
            return (ViewQuery)queries[n];
        }
        return null;
    }

    private static BOrd getOrdWithoutViewQuery(OrdQuery[] queries) {
        if (OrdUtil.getViewQuery(queries) == null) {
            return BOrd.make((OrdQuery[])queries);
        }
        return BOrd.make((OrdQuery[])queries, (int)0, (int)(queries.length - 1));
    }
}

