/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.BHxWebWidget;
import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.sys.registry.NAgentList;
import com.tridium.web.WebEnv;
import com.tridium.web.WebUtil;
import com.tridium.workbench.propsheet.BPropertySheet;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.px.BHxPxView;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.naming.OrdTarget;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.web.BIWebProfile;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.js.BIJavaScript;
import javax.baja.workbench.view.BWbView;
import javax.baja.workbench.view.BWbViewBinding;

public class BHxPxWbView
extends BHxPxWidget {
    public static final BHxPxWbView INSTANCE = new BHxPxWbView();
    public static final Type TYPE = Sys.loadType(BHxPxWbView.class);
    static AgentFilter isHxFilter = AgentFilter.is((Type)BHxView.TYPE);
    public static final Logger log = Logger.getLogger("hx.px");
    public static AgentFilter webWidgetFilter = new WebWidgetFilter();
    private static boolean ENABLE_PROPERTY_SHEET_TRANSLATION = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.translatePropertySheetToBajaux"));
    private static boolean DISABLED_BAJAUX_WB_VIEWS = AccessController.doPrivileged(() -> Boolean.getBoolean("hx.disableBajauxWbViews"));

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxWbView() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        block6: {
            try {
                if (op.get() instanceof BWbView) {
                    BWbView wbView = (BWbView)op.get();
                    BHxView hxView = BHxPxWbView.getAgent(wbView, (BIWebProfile)op.getProfile(), (Context)op);
                    if (log.isLoggable(Level.FINE)) {
                        op.getHtmlWriter().w((Object)"\n<!-- BHxPxWbView.view: ").w((Object)hxView.getType()).w((Object)" -->\n");
                    }
                    hxView.write(this.makeOp(wbView, hxView, op));
                }
            }
            catch (NoSuchAgentException nsae) {
                if (BHxPxView.log.isLoggable(Level.FINE)) {
                    BHxPxView.log.log(Level.FINE, "No BHxView for " + op.get().getType());
                }
            }
            catch (Exception e) {
                if (!BHxPxView.log.isLoggable(Level.FINE)) break block6;
                BHxPxView.log.log(Level.FINE, "BHxPxWbView.write ", e);
            }
        }
    }

    @Override
    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        block4: {
            try {
                if (op.get() instanceof BWbView) {
                    BWbView wbView = (BWbView)op.get();
                    BHxView hxView = BHxPxWbView.getAgent(wbView, (BIWebProfile)op.getProfile(), (Context)op);
                    hxView.update(this.makeOp(wbView, hxView, op));
                }
            }
            catch (NoSuchAgentException wbView) {
            }
            catch (Exception e) {
                if (!BHxPxView.log.isLoggable(Level.FINE)) break block4;
                BHxPxView.log.log(Level.FINE, "BHxPxWbView.update ", e);
            }
        }
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        block5: {
            if (super.process(op)) {
                return true;
            }
            try {
                if (op.get() instanceof BWbView) {
                    BWbView wbView = (BWbView)op.get();
                    BHxView hxView = BHxPxWbView.getAgent(wbView, (BIWebProfile)op.getProfile(), (Context)op);
                    return hxView.process(this.makeOp(wbView, hxView, op));
                }
            }
            catch (NoSuchAgentException wbView) {
            }
            catch (Exception e) {
                if (!BHxPxView.log.isLoggable(Level.FINE)) break block5;
                BHxPxView.log.log(Level.FINE, "BHxPxWbView.process ", e);
            }
        }
        return false;
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        block4: {
            try {
                if (op.get() instanceof BWbView) {
                    BWbView wbView = (BWbView)op.get();
                    BHxView hxView = BHxPxWbView.getAgent(wbView, (BIWebProfile)op.getProfile(), (Context)op);
                    return hxView.save(this.makeOp(wbView, hxView, op));
                }
            }
            catch (NoSuchAgentException wbView) {
            }
            catch (Exception e) {
                if (!BHxPxView.log.isLoggable(Level.FINE)) break block4;
                BHxPxView.log.log(Level.FINE, "BHxPxWbView.save ", e);
            }
        }
        return op.get();
    }

    @Override
    public BWidget[] getChildWidgets(BWidget widget, Context cx) {
        try {
            BIWebProfile profile;
            BHxView hxView;
            BWbView wbView = (BWbView)widget;
            if (wbView instanceof BWbView && (hxView = BHxPxWbView.getAgent(wbView, profile = HxHyperlinkInfo.getProfile(cx), cx)) != null && !(hxView instanceof BHxPxWbView)) {
                return new BWidget[0];
            }
            return wbView.getChildWidgets();
        }
        catch (Exception e) {
            BWbView wbView = (BWbView)widget;
            return wbView.getChildWidgets();
        }
    }

    @Override
    public boolean needsUpdate(BAbsTime lastUpdate, BAbsTime lastModified) {
        return true;
    }

    @Override
    public MouseEventCommand getMouseEventHandler() {
        return null;
    }

    private HxOp makeOp(BWbView view, BHxView hxView, HxOp base) {
        if (hxView instanceof BHxWebWidget) {
            return base;
        }
        for (BBinding binding : view.getBindings()) {
            if (!(binding instanceof BWbViewBinding)) continue;
            WebOp c = base.getWebOp();
            OrdTarget target = binding.getOrd().resolve(c.get(), (Context)c);
            HxOp op = base.make(target);
            op.setConfig((BComplex)view);
            return op;
        }
        return null;
    }

    public static AgentList getNonWbViewAgents(BWbView view) {
        NAgentList list = new NAgentList();
        TypeInfo typeInfo = view.getType().getTypeInfo();
        while (!typeInfo.equals(BWbView.TYPE.getTypeInfo())) {
            Arrays.stream(Sys.getRegistry().getSpecificAgents(typeInfo).list()).forEach(arg_0 -> BHxPxWbView.lambda$getNonWbViewAgents$0((AgentList)list, arg_0));
            typeInfo = typeInfo.getSuperType();
        }
        return list;
    }

    public static BHxView getAgent(BWbView view, BIWebProfile profile, Context cx) {
        if (BHxPxWbView.canTranslateToBajaux(view)) {
            try {
                AgentInfo agentInfo = BHxPxWbView.getNonWbViewAgents(view).filter(AgentFilter.and((AgentFilter)webWidgetFilter, (AgentFilter)new WebUtil.ProfileFilter(profile, (BObject)view))).getDefault();
                IWebEnv env = BHxProfile.webEnv();
                WebOp webOp = cx instanceof WebOp ? (WebOp)cx : null;
                agentInfo = env.translate(webOp, agentInfo);
                if (agentInfo.getAgentType().is(WebEnv.hxView)) {
                    return (BHxView)agentInfo.getInstance();
                }
            }
            catch (NoSuchAgentException noSuchAgentException) {
                // empty catch block
            }
        }
        return (BHxView)view.getAgents().filter(AgentFilter.and((AgentFilter)isHxFilter, (AgentFilter)new WebUtil.ProfileFilter(profile, (BObject)view))).getDefault().getInstance();
    }

    private static boolean canTranslateToBajaux(BWbView view) {
        if (DISABLED_BAJAUX_WB_VIEWS) {
            return false;
        }
        if (view.getType().is(BPropertySheet.TYPE)) {
            return ENABLE_PROPERTY_SHEET_TRANSLATION;
        }
        return true;
    }

    private static /* synthetic */ void lambda$getNonWbViewAgents$0(AgentList list, AgentInfo e) {
        list.add(list.size(), e);
    }

    public static class WebWidgetFilter
    extends AgentFilter {
        public boolean include(AgentInfo agent) {
            return agent.getAgentType().is(WebEnv.formFactorMax) && agent.getAgentType().is(BIJavaScript.TYPE);
        }
    }
}

